/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.PostProcessor;
import ai.djl.translate.PreProcessor;
import ai.djl.translate.TranslatorContext;
import ai.djl.translate.TranslatorOptions;
import java.util.ArrayList;
import java.util.List;

public interface Translator<I, O>
extends PreProcessor<I>,
PostProcessor<O> {
    default public Batchifier getBatchifier() {
        return Batchifier.STACK;
    }

    default public NDList batchProcessInput(TranslatorContext ctx, List<I> inputs) throws Exception {
        NDList[] preprocessed = new NDList[inputs.size()];
        int index = 0;
        for (I input : inputs) {
            preprocessed[index++] = this.processInput(ctx, input);
        }
        return this.getBatchifier().batchify(preprocessed);
    }

    default public List<O> batchProcessOutput(TranslatorContext ctx, NDList list) throws Exception {
        NDList[] unbatched = this.getBatchifier().unbatchify(list);
        ArrayList outputs = new ArrayList(unbatched.length);
        for (NDList output : unbatched) {
            outputs.add(this.processOutput(ctx, output));
        }
        return outputs;
    }

    default public void prepare(TranslatorContext ctx) throws Exception {
    }

    default public TranslatorOptions getExpansions() {
        return null;
    }
}

