/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.listener;

import ai.djl.metric.Metric;
import ai.djl.metric.Metrics;
import ai.djl.training.Trainer;
import ai.djl.training.listener.TrainingListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeMeasureTrainingListener
implements TrainingListener {
    private static final Logger logger = LoggerFactory.getLogger(TimeMeasureTrainingListener.class);
    private String outputDir;

    public TimeMeasureTrainingListener(String outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void onEpoch(Trainer trainer) {
    }

    @Override
    public void onTrainingBatch(Trainer trainer, TrainingListener.BatchData batchData) {
    }

    @Override
    public void onValidationBatch(Trainer trainer, TrainingListener.BatchData batchData) {
    }

    @Override
    public void onTrainingBegin(Trainer trainer) {
    }

    @Override
    public void onTrainingEnd(Trainer trainer) {
        Metrics metrics = trainer.getMetrics();
        TimeMeasureTrainingListener.dumpTrainingTimeInfo(metrics, this.outputDir);
    }

    private static void dumpTrainingTimeInfo(Metrics metrics, String logDir) {
        if (logDir == null) {
            return;
        }
        try {
            Path dir = Paths.get(logDir, new String[0]);
            Files.createDirectories(dir, new FileAttribute[0]);
            Path file = dir.resolve("training.log");
            try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
                List<Metric> list = metrics.getMetric("train");
                for (Metric metric : list) {
                    writer.append(metric.toString());
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            logger.error("Failed dump training log", (Throwable)e);
        }
    }
}

