/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class NDList
extends ArrayList<NDArray>
implements AutoCloseable {
    private static final long serialVersionUID = 1L;

    public NDList() {
    }

    public NDList(int initialCapacity) {
        super(initialCapacity);
    }

    public NDList(NDArray ... arrays) {
        super(Arrays.asList(arrays));
    }

    public NDList(Collection<NDArray> other) {
        super(other);
    }

    public NDArray remove(String name) {
        int index = 0;
        for (NDArray array : this) {
            if (name.equals(array.getName())) {
                this.remove(index);
                return array;
            }
            ++index;
        }
        return null;
    }

    public boolean contains(String name) {
        for (NDArray array : this) {
            if (!name.equals(array.getName())) continue;
            return true;
        }
        return false;
    }

    public NDArray head() {
        return (NDArray)this.get(0);
    }

    public NDArray singletonOrThrow() {
        if (this.size() != 1) {
            throw new IndexOutOfBoundsException("Incorrect number of elements in NDList.singletonOrThrow: Expected 1 and was " + this.size());
        }
        return (NDArray)this.get(0);
    }

    public NDList addAll(NDList other) {
        for (NDArray array : other) {
            this.add(array);
        }
        return this;
    }

    public NDList subNDList(int fromIndex) {
        return new NDList((Collection<NDArray>)this.subList(fromIndex, this.size()));
    }

    public NDList asInDevice(Device device, boolean copy) {
        if (!copy && this.stream().allMatch(array -> array.getDevice() == device)) {
            return this;
        }
        NDList newNDList = new NDList(this.size());
        this.forEach((? super E a) -> newNDList.add(a.toDevice(device, copy)));
        return newNDList;
    }

    public void attach(NDManager manager) {
        this.forEach((? super E a) -> a.attach(manager));
    }

    public void detach() {
        this.forEach(NDArray::detach);
    }

    @Override
    public void close() {
        this.forEach(NDArray::close);
        this.clear();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("NDList size: ").append(this.size()).append('\n');
        int index = 0;
        for (NDArray array : this) {
            String name = array.getName();
            builder.append(index++).append(' ');
            if (name != null) {
                builder.append(name);
            }
            builder.append(": ").append(array.getShape()).append(' ').append((Object)array.getDataType()).append('\n');
        }
        return builder.toString();
    }
}

