/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.translator;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;

public class TextEmbeddingServingTranslator
implements Translator<Input, Output> {
    private Translator<String, float[]> translator;

    public TextEmbeddingServingTranslator(Translator<String, float[]> translator) {
        this.translator = translator;
    }

    @Override
    public Batchifier getBatchifier() {
        return this.translator.getBatchifier();
    }

    @Override
    public void prepare(TranslatorContext ctx) throws Exception {
        this.translator.prepare(ctx);
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Input input) throws Exception {
        String text = input.getData().getAsString();
        return this.translator.processInput(ctx, text);
    }

    @Override
    public Output processOutput(TranslatorContext ctx, NDList list) throws Exception {
        float[] ret = (float[])this.translator.processOutput(ctx, list);
        Output output = new Output();
        output.add(JsonUtils.GSON_PRETTY.toJson((Object)ret));
        return output;
    }
}

