/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.translator.ImageFeatureExtractor;
import ai.djl.modality.cv.translator.ImageServingTranslator;
import ai.djl.modality.cv.translator.wrapper.FileTranslator;
import ai.djl.modality.cv.translator.wrapper.InputStreamTranslator;
import ai.djl.modality.cv.translator.wrapper.UrlTranslator;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ImageFeatureExtractorFactory
implements TranslatorFactory {
    private static final Set<Pair<Type, Type>> SUPPORTED_TYPES = new HashSet<Pair<Type, Type>>();

    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) {
        ImageFeatureExtractor translator = ImageFeatureExtractor.builder(arguments).build();
        if (input == Image.class && output == byte[].class) {
            return translator;
        }
        if (input == Path.class && output == byte[].class) {
            return new FileTranslator<byte[]>(translator);
        }
        if (input == URL.class && output == byte[].class) {
            return new UrlTranslator<byte[]>(translator);
        }
        if (input == InputStream.class && output == byte[].class) {
            return new InputStreamTranslator<byte[]>(translator);
        }
        if (input == Input.class && output == Output.class) {
            return new ImageServingTranslator(translator);
        }
        throw new IllegalArgumentException("Unsupported input/output types.");
    }

    static {
        SUPPORTED_TYPES.add(new Pair<Class<Image>, Class<byte[]>>(Image.class, byte[].class));
        SUPPORTED_TYPES.add(new Pair<Class<Path>, Class<byte[]>>(Path.class, byte[].class));
        SUPPORTED_TYPES.add(new Pair<Class<URL>, Class<byte[]>>(URL.class, byte[].class));
        SUPPORTED_TYPES.add(new Pair<Class<InputStream>, Class<byte[]>>(InputStream.class, byte[].class));
        SUPPORTED_TYPES.add(new Pair<Class<Input>, Class<Output>>(Input.class, Output.class));
    }
}

