/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.metrics;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;

public abstract class TrainingMetric
implements Cloneable {
    private String name;

    public TrainingMetric(String name) {
        this.name = name;
    }

    public TrainingMetric duplicate() {
        try {
            return (TrainingMetric)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("Clone is not supported", e);
        }
    }

    public abstract void update(NDList var1, NDList var2);

    public abstract void reset();

    public String getName() {
        return this.name;
    }

    public abstract float getValue();

    protected void checkLabelShapes(NDArray labels, NDArray predictions, boolean checkDimOnly) {
        if (labels.getShape().get(0) != predictions.getShape().get(0)) {
            throw new IllegalArgumentException("The size of labels(" + labels.size() + ") does not match that of predictions(" + predictions.size() + ")");
        }
        if (!checkDimOnly && labels.getShape() != predictions.getShape()) {
            throw new IllegalArgumentException("The shape of labels(" + labels.getShape() + ") does not match that of predictions(" + predictions.getShape() + ")");
        }
    }

    protected void checkLabelShapes(NDArray labels, NDArray predictions) {
        this.checkLabelShapes(labels, predictions, true);
    }
}

