/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.Classifications;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.translator.ImageClassificationTranslator;
import ai.djl.modality.cv.translator.ImageServingTranslator;
import ai.djl.modality.cv.translator.wrapper.FileTranslator;
import ai.djl.modality.cv.translator.wrapper.InputStreamTranslator;
import ai.djl.modality.cv.translator.wrapper.UrlTranslator;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ImageClassificationTranslatorFactory
implements TranslatorFactory {
    private static final Set<Pair<Type, Type>> SUPPORTED_TYPES = new HashSet<Pair<Type, Type>>();

    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public Translator<?, ?> newInstance(Class<?> input, Class<?> output, Model model, Map<String, ?> arguments) {
        if (input == Image.class && output == Classifications.class) {
            return ImageClassificationTranslator.builder(arguments).build();
        }
        if (input == Path.class && output == Classifications.class) {
            return new FileTranslator<Classifications>(ImageClassificationTranslator.builder(arguments).build());
        }
        if (input == URL.class && output == Classifications.class) {
            return new UrlTranslator<Classifications>(ImageClassificationTranslator.builder(arguments).build());
        }
        if (input == InputStream.class && output == Classifications.class) {
            return new InputStreamTranslator<Classifications>(ImageClassificationTranslator.builder(arguments).build());
        }
        if (input == Input.class && output == Output.class) {
            return new ImageServingTranslator(ImageClassificationTranslator.builder(arguments).build());
        }
        throw new IllegalArgumentException("Unsupported input/output types.");
    }

    static {
        SUPPORTED_TYPES.add(new Pair<Class<Image>, Class<Classifications>>(Image.class, Classifications.class));
        SUPPORTED_TYPES.add(new Pair<Class<Path>, Class<Classifications>>(Path.class, Classifications.class));
        SUPPORTED_TYPES.add(new Pair<Class<URL>, Class<Classifications>>(URL.class, Classifications.class));
        SUPPORTED_TYPES.add(new Pair<Class<InputStream>, Class<Classifications>>(InputStream.class, Classifications.class));
        SUPPORTED_TYPES.add(new Pair<Class<Input>, Class<Output>>(Input.class, Output.class));
    }
}

