/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.transform.CenterCrop;
import ai.djl.modality.cv.transform.Normalize;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class BaseImageTranslator<T>
implements Translator<Image, T> {
    private static final float[] MEAN = new float[]{0.485f, 0.456f, 0.406f};
    private static final float[] STD = new float[]{0.229f, 0.224f, 0.225f};
    protected Pipeline pipeline;
    private Image.Flag flag;
    private Batchifier batchifier;

    public BaseImageTranslator(BaseBuilder<?> builder) {
        this.flag = builder.flag;
        this.pipeline = builder.pipeline;
        this.batchifier = builder.batchifier;
    }

    @Override
    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray array = input.toNDArray(ctx.getNDManager(), this.flag);
        return this.pipeline.transform(new NDList(array));
    }

    protected static final class SynsetLoader {
        private String synsetFileName;
        private URL synsetUrl;
        private List<String> synset;

        public SynsetLoader(List<String> synset) {
            this.synset = synset;
        }

        public SynsetLoader(URL synsetUrl) {
            this.synsetUrl = synsetUrl;
        }

        public SynsetLoader(String synsetFileName) {
            this.synsetFileName = synsetFileName;
        }

        public List<String> load(Model model) throws IOException {
            if (this.synset != null) {
                return this.synset;
            }
            if (this.synsetUrl != null) {
                try (InputStream is = this.synsetUrl.openStream();){
                    List<String> list = Utils.readLines(is);
                    return list;
                }
            }
            return model.getArtifact(this.synsetFileName, Utils::readLines);
        }
    }

    public static abstract class ClassificationBuilder<T extends BaseBuilder>
    extends BaseBuilder<T> {
        protected SynsetLoader synsetLoader;

        public T optSynsetArtifactName(String synsetArtifactName) {
            this.synsetLoader = new SynsetLoader(synsetArtifactName);
            return this.self();
        }

        public T optSynsetUrl(String synsetUrl) {
            try {
                this.synsetLoader = new SynsetLoader(new URL(synsetUrl));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid synsetUrl: " + synsetUrl, e);
            }
            return this.self();
        }

        public T optSynset(List<String> synset) {
            this.synsetLoader = new SynsetLoader(synset);
            return this.self();
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.synsetLoader == null) {
                this.synsetLoader = new SynsetLoader("synset.txt");
            }
        }

        @Override
        protected void configPostProcess(Map<String, ?> arguments) {
            String synsetFileName;
            String synsetUrl;
            String synset = (String)arguments.get("synset");
            if (synset != null) {
                this.optSynset(Arrays.asList(synset.split(",")));
            }
            if ((synsetUrl = (String)arguments.get("synsetUrl")) != null) {
                this.optSynsetUrl(synsetUrl);
            }
            if ((synsetFileName = (String)arguments.get("synsetFileName")) != null) {
                this.optSynsetArtifactName(synsetFileName);
            }
        }
    }

    public static abstract class BaseBuilder<T extends BaseBuilder> {
        protected int width = 224;
        protected int height = 224;
        protected Image.Flag flag = Image.Flag.COLOR;
        protected Pipeline pipeline;
        protected Batchifier batchifier = Batchifier.STACK;

        public T optFlag(Image.Flag flag) {
            this.flag = flag;
            return this.self();
        }

        public T setPipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this.self();
        }

        public T addTransform(Transform transform) {
            if (this.pipeline == null) {
                this.pipeline = new Pipeline();
            }
            this.pipeline.add(transform);
            return this.self();
        }

        public T optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this.self();
        }

        protected abstract T self();

        protected void validate() {
            if (this.pipeline == null) {
                throw new IllegalArgumentException("pipeline is required.");
            }
        }

        protected void configPreProcess(Map<String, ?> arguments) {
            String normalize;
            String resize;
            if (this.pipeline == null) {
                this.pipeline = new Pipeline();
            }
            this.width = ArgumentsUtil.intValue(arguments, "width", 224);
            this.height = ArgumentsUtil.intValue(arguments, "height", 224);
            if (arguments.containsKey("flag")) {
                this.flag = Image.Flag.valueOf(arguments.get("flag").toString());
            }
            if ("true".equals(resize = ArgumentsUtil.stringValue(arguments, "resize", "false"))) {
                this.addTransform(new Resize(this.width, this.height));
            } else if (!"false".equals(resize)) {
                String[] tokens = resize.split("\\s*,\\s*");
                if (tokens.length > 1) {
                    this.addTransform(new Resize((int)Double.parseDouble(tokens[0]), (int)Double.parseDouble(tokens[1])));
                } else {
                    this.addTransform(new Resize((int)Double.parseDouble(tokens[0])));
                }
            }
            if (ArgumentsUtil.booleanValue(arguments, "centerCrop", false)) {
                this.addTransform(new CenterCrop(this.width, this.height));
            }
            if (ArgumentsUtil.booleanValue(arguments, "toTensor", true)) {
                this.addTransform(new ToTensor());
            }
            if ("true".equals(normalize = ArgumentsUtil.stringValue(arguments, "normalize", "false"))) {
                this.addTransform(new Normalize(MEAN, STD));
            } else if (!"false".equals(normalize)) {
                String[] tokens = normalize.split("\\s*,\\s*");
                if (tokens.length != 6) {
                    throw new IllegalArgumentException("Invalid normalize value: " + normalize);
                }
                float[] mean = new float[]{Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2])};
                float[] std = new float[]{Float.parseFloat(tokens[3]), Float.parseFloat(tokens[4]), Float.parseFloat(tokens[5])};
                this.addTransform(new Normalize(mean, std));
            }
            String range = (String)arguments.get("range");
            if ("0,1".equals(range)) {
                this.addTransform(a -> a.div(Float.valueOf(255.0f)));
            } else if ("-1,1".equals(range)) {
                this.addTransform(a -> a.div(Float.valueOf(128.0f)).sub(1));
            }
            if (arguments.containsKey("batchifier")) {
                this.batchifier = Batchifier.fromString((String)arguments.get("batchifier"));
            }
        }

        protected void configPostProcess(Map<String, ?> arguments) {
        }
    }
}

