/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import ai.djl.util.cuda.CudaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public final class Platform {
    private String version;
    private String osPrefix;
    private String osArch;
    private String flavor;
    private String cudaArch;
    private String[] libraries;
    private boolean placeholder;

    private Platform() {
    }

    public static Platform fromUrl(URL url) throws IOException {
        Platform platform = Platform.fromSystem();
        try (InputStream conf = url.openStream();){
            Properties prop = new Properties();
            prop.load(conf);
            platform.version = prop.getProperty("version");
            if (platform.version == null) {
                throw new IllegalArgumentException("version key is required in <engine>.properties file.");
            }
            platform.placeholder = prop.getProperty("placeholder") != null;
            String flavorPrefixedClassifier = prop.getProperty("classifier", "");
            String libraryList = prop.getProperty("libraries", "");
            platform.libraries = libraryList.isEmpty() ? new String[0] : libraryList.split(",");
            if (!flavorPrefixedClassifier.isEmpty()) {
                String[] tokens = flavorPrefixedClassifier.split("-");
                platform.flavor = tokens[0];
                platform.osPrefix = tokens[1];
                platform.osArch = tokens[2];
            }
        }
        return platform;
    }

    public static Platform fromSystem() {
        Platform platform = new Platform();
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Win")) {
            platform.osPrefix = "win";
        } else if (osName.startsWith("Mac")) {
            platform.osPrefix = "osx";
        } else if (osName.startsWith("Linux")) {
            platform.osPrefix = "linux";
        } else {
            throw new AssertionError((Object)("Unsupported platform: " + osName));
        }
        platform.osArch = System.getProperty("os.arch");
        if ("amd64".equals(platform.osArch)) {
            platform.osArch = "x86_64";
        }
        if (CudaUtils.getGpuCount() > 0) {
            platform.flavor = "cu" + CudaUtils.getCudaVersionString();
            platform.cudaArch = CudaUtils.getComputeCapability(0);
        } else {
            platform.flavor = "cpu";
        }
        return platform;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOsPrefix() {
        return this.osPrefix;
    }

    public String getOsArch() {
        return this.osArch;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public String getClassifier() {
        return this.osPrefix + '-' + this.osArch;
    }

    public String getCudaArch() {
        return this.cudaArch;
    }

    public String[] getLibraries() {
        return this.libraries;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public boolean matches(Platform system) {
        return this.matches(system, true);
    }

    public boolean matches(Platform system, boolean strictModel) {
        if (!this.osPrefix.equals(system.osPrefix) || !this.osArch.equals(system.osArch)) {
            return false;
        }
        if (system.flavor.startsWith("cu")) {
            return "cpu".equals(this.flavor) || "mkl".equals(this.flavor) || this.flavor.startsWith(system.flavor) || !strictModel && this.flavor.compareTo(system.flavor) <= 0;
        }
        return "cpu".equals(this.flavor) || "mkl".equals(this.flavor);
    }
}

