/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp;

import ai.djl.modality.nlp.Vocabulary;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class SimpleVocabulary
implements Vocabulary {
    private Map<String, TokenInfo> tokens = new ConcurrentHashMap<String, TokenInfo>();
    private List<String> indexToToken = new ArrayList<String>();
    private Set<String> reservedTokens;
    private int minFrequency;
    private String unknownToken;

    public SimpleVocabulary(Builder builder) {
        this.reservedTokens = builder.reservedTokens;
        this.minFrequency = builder.minFrequency;
        this.unknownToken = builder.unknownToken;
        this.reservedTokens.add(this.unknownToken);
        this.addTokens(this.reservedTokens);
        for (List<String> sentence : builder.sentences) {
            for (String word : sentence) {
                this.addWord(word);
            }
        }
    }

    public SimpleVocabulary(List<String> tokens) {
        this.reservedTokens = new HashSet<String>();
        this.minFrequency = 10;
        this.unknownToken = "<unk>";
        this.reservedTokens.add(this.unknownToken);
        this.addTokens(this.reservedTokens);
        this.addTokens(tokens);
    }

    private void addWord(String token) {
        if (this.reservedTokens.contains(token)) {
            return;
        }
        TokenInfo tokenInfo = this.tokens.getOrDefault(token, new TokenInfo());
        if (++tokenInfo.frequency == this.minFrequency) {
            tokenInfo.index = this.tokens.size();
            this.indexToToken.add(token);
        }
        this.tokens.put(token, tokenInfo);
    }

    private void addTokens(Collection<String> tokens) {
        for (String token : tokens) {
            TokenInfo tokenInfo = new TokenInfo();
            tokenInfo.frequency = Integer.MAX_VALUE;
            tokenInfo.index = this.indexToToken.size();
            this.indexToToken.add(token);
            this.tokens.put(token, tokenInfo);
        }
    }

    @Override
    public boolean contains(String token) {
        return this.tokens.containsKey(token);
    }

    @Override
    public String getToken(long index) {
        if (index < 0L || index >= (long)this.indexToToken.size()) {
            return this.unknownToken;
        }
        return this.indexToToken.get((int)index);
    }

    @Override
    public long getIndex(String token) {
        if (this.tokens.containsKey(token)) {
            TokenInfo tokenInfo = this.tokens.get(token);
            if (tokenInfo.frequency >= this.minFrequency) {
                return tokenInfo.index;
            }
        }
        return this.tokens.get((Object)this.unknownToken).index;
    }

    @Override
    public long size() {
        return this.tokens.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class TokenInfo {
        int frequency;
        long index = -1L;
    }

    public static final class Builder {
        List<List<String>> sentences = new ArrayList<List<String>>();
        Set<String> reservedTokens = new HashSet<String>();
        int minFrequency = 10;
        String unknownToken = "<unk>";

        private Builder() {
        }

        public Builder optMinFrequency(int minFrequency) {
            this.minFrequency = minFrequency;
            return this;
        }

        public Builder optUnknownToken(String unknownToken) {
            this.unknownToken = unknownToken;
            return this;
        }

        public Builder optReservedTokens(Collection<String> reservedTokens) {
            this.reservedTokens.addAll(reservedTokens);
            return this;
        }

        public Builder add(List<String> sentence) {
            this.sentences.add(sentence);
            return this;
        }

        public Builder addAll(List<List<String>> sentences) {
            this.sentences.addAll(sentences);
            return this;
        }

        public Builder addFromTextFile(Path path) throws IOException {
            this.add(Utils.readLines(path, true));
            return this;
        }

        public Builder addFromTextFile(URL url) throws IOException {
            try (InputStream is = url.openStream();){
                this.add(Utils.readLines(is, true));
            }
            return this;
        }

        public Builder addFromCustomizedFile(URL url, Function<URL, List<String>> lambda) {
            return this.add(lambda.apply(url));
        }

        public SimpleVocabulary build() {
            return new SimpleVocabulary(this);
        }
    }
}

