/*
 * Decompiled with CFR 0.152.
 */
package ai.djl;

import ai.djl.engine.Engine;
import ai.djl.util.cuda.CudaUtils;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class Device {
    private static final Map<String, Device> CACHE = new ConcurrentHashMap<String, Device>();
    private static final Device CPU = new Device("cpu", -1);
    private static final Device GPU = Device.of("gpu", 0);
    private String deviceType;
    private int deviceId;

    private Device(String deviceType, int deviceId) {
        this.deviceType = deviceType;
        this.deviceId = deviceId;
    }

    public static Device of(String deviceType, int deviceId) {
        if ("cpu".equals(deviceType)) {
            return CPU;
        }
        String key = deviceType + '-' + deviceId;
        return CACHE.computeIfAbsent(key, k -> new Device(deviceType, deviceId));
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public String toString() {
        if ("cpu".equals(this.deviceType)) {
            return this.deviceType + "()";
        }
        return this.deviceType + '(' + this.deviceId + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        if ("cpu".equals(this.deviceType)) {
            return Objects.equals(this.deviceType, device.deviceType);
        }
        return this.deviceId == device.deviceId && Objects.equals(this.deviceType, device.deviceType);
    }

    public int hashCode() {
        return Objects.hash(this.deviceType, this.deviceId);
    }

    public static Device cpu() {
        return CPU;
    }

    public static Device gpu() {
        return GPU;
    }

    public static Device gpu(int deviceId) {
        return Device.of("gpu", deviceId);
    }

    public static Device[] getDevices() {
        return Device.getDevices(Integer.MAX_VALUE);
    }

    public static Device[] getDevices(int maxGpus) {
        int count = Device.getGpuCount();
        if (maxGpus <= 0 || count <= 0) {
            return new Device[]{CPU};
        }
        count = Math.min(maxGpus, count);
        Device[] devices = new Device[count];
        for (int i = 0; i < count; ++i) {
            devices[i] = Device.gpu(i);
        }
        return devices;
    }

    public static int getGpuCount() {
        if (Engine.getInstance().hasCapability("CUDA")) {
            return CudaUtils.getGpuCount();
        }
        return 0;
    }

    public static Device defaultDevice() {
        return Device.defaultDevice(Engine.getInstance());
    }

    public static Device defaultDevice(Engine engine) {
        return engine.defaultDevice();
    }

    public static Device defaultIfNull(Device device, Engine engine) {
        if (device != null) {
            return device;
        }
        return Device.defaultDevice(engine);
    }

    public static interface Type {
        public static final String CPU = "cpu";
        public static final String GPU = "gpu";
    }
}

