/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.transformer;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.AbstractBlock;
import ai.djl.nn.Parameter;
import ai.djl.nn.ParameterType;
import ai.djl.nn.transformer.MissingOps;
import ai.djl.training.ParameterStore;
import ai.djl.util.PairList;
import java.util.Arrays;

public final class IdEmbedding
extends AbstractBlock {
    private static final byte VERSION = 1;
    private static final String EMBEDDING_PARAM_NAME = "embedding";
    private final int dictionarySize;
    private final int embeddingSize;
    private final Parameter embedding;

    private IdEmbedding(Builder builder) {
        super((byte)1);
        this.dictionarySize = builder.dictionarySize;
        this.embeddingSize = builder.embeddingSize;
        this.embedding = this.addParameter(new Parameter(EMBEDDING_PARAM_NAME, this, ParameterType.WEIGHT), new Shape(this.dictionarySize, this.embeddingSize));
    }

    @Override
    public Shape[] getOutputShapes(NDManager manager, Shape[] inputShapes) {
        return new Shape[]{inputShapes[0].addAll(new Shape(this.embeddingSize))};
    }

    @Override
    protected NDList forwardInternal(ParameterStore ps, NDList inputs, boolean training, PairList<String, Object> params) {
        return this.forward(ps, inputs, training);
    }

    @Override
    public NDList forward(ParameterStore ps, NDList inputs, boolean training) {
        return new NDList(inputs.singletonOrThrow());
    }

    public NDArray forward(ParameterStore parameterStore, NDArray input, boolean training) {
        NDArray ids = input.flatten().reshape(1L, input.getShape().size());
        NDArray embeddingTable = parameterStore.getValue(this.embedding, ids.getDevice(), training);
        NDArray result = MissingOps.gatherNd(embeddingTable, ids);
        Shape targetShape = input.getShape().addAll(new Shape(embeddingTable.getShape().get(1)));
        return result.reshape(targetShape);
    }

    public NDArray probabilities(ParameterStore parameterStore, NDArray input, boolean training) {
        NDArray asMatrix = input.reshape(-1L, this.embeddingSize);
        NDArray embeddingTableTransposed = parameterStore.getValue(this.embedding, input.getDevice(), training).transpose();
        embeddingTableTransposed.attach(input.getManager());
        NDArray logitsFlat = asMatrix.dot(embeddingTableTransposed);
        NDArray logProbsFlat = logitsFlat.logSoftmax(1);
        Shape targetShape = input.getShape().slice(0, input.getShape().dimension() - 1).addAll(new Shape(this.dictionarySize));
        return logProbsFlat.reshape(targetShape);
    }

    public NDArray getValue(ParameterStore ps, Device device, boolean training) {
        return ps.getValue(this.embedding, device, training);
    }

    @Override
    public void initializeChildBlocks(NDManager manager, DataType dataType, Shape ... inputShapes) {
        this.inputNames = Arrays.asList("tokenIds");
    }

    public static final class Builder {
        private int dictionarySize;
        private int embeddingSize;

        public Builder setDictionarySize(int dictionarySize) {
            this.dictionarySize = dictionarySize;
            return this;
        }

        public Builder setEmbeddingSize(int embeddingSize) {
            this.embeddingSize = embeddingSize;
            return this;
        }

        public IdEmbedding build() {
            if (this.dictionarySize <= 0) {
                throw new IllegalArgumentException("You must specify the dictionary Size for the embedding.");
            }
            if (this.embeddingSize == 0) {
                throw new IllegalArgumentException("You must specify the embedding size");
            }
            return new IdEmbedding(this);
        }
    }
}

