/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.schema;

import ai.databand.id.Uuid5;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.UUID;

public class AirflowTaskContext {
    private final String airflowInstanceUid;
    private final String airflowName;
    private final String dagId;
    private final String executionDate;
    private final String taskId;
    private final String tryNumber;

    public AirflowTaskContext(String airflowInstanceUid, String airflowName, String dagId, String executionDate, String taskId, String tryNumber) {
        this.airflowInstanceUid = airflowInstanceUid;
        this.airflowName = airflowName;
        this.dagId = dagId;
        this.executionDate = executionDate;
        this.taskId = taskId;
        this.tryNumber = tryNumber;
    }

    public String getAirflowInstanceUid() {
        return this.airflowInstanceUid;
    }

    public String getAirflowName() {
        return this.airflowName;
    }

    public String getDagId() {
        return this.dagId;
    }

    public String getExecutionDate() {
        return this.executionDate;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTryNumber() {
        return this.tryNumber;
    }

    @JsonIgnore
    public String getAfOperatorUid() {
        String airflowSyncRunUid = this.buildAirflowJobRunUid();
        return this.buildAirflowTaskRunUid(airflowSyncRunUid);
    }

    @JsonIgnore
    protected String buildAirflowJobRunUid() {
        if (this.airflowInstanceUid == null) {
            return new Uuid5(Uuid5.NAMESPACE_DBND_RUN, String.format("%s:%s", this.getDagId(), this.getExecutionDate())).toString();
        }
        return new Uuid5(Uuid5.NAMESPACE_DBND_RUN, String.format("%s:%s:%s", this.getAirflowInstanceUid(), this.getDagId(), this.getExecutionDate())).toString();
    }

    @JsonIgnore
    protected String buildAirflowTaskRunUid(String runUid) {
        return new Uuid5(UUID.fromString(runUid), String.format("%s.%s", this.getDagId(), this.getTaskId())).toString();
    }

    @JsonIgnore
    protected String buildAirflowTaskDefUid(AirflowTaskContext context) {
        return new Uuid5(Uuid5.NAMESPACE_DBND_TASK_DEF, String.format("%s.%s", context.getDagId(), context.getTaskId())).toString();
    }

    @JsonIgnore
    protected String buildAirflowTaskRunAttemptUid(String runUid, AirflowTaskContext context) {
        return new Uuid5(UUID.fromString(runUid), String.format("%s.%s:%s", context.getDagId(), context.getTaskId(), context.getTryNumber())).toString();
    }

    @JsonIgnore
    protected String buildAirflowJobUid(AirflowTaskContext context) {
        if (context.getAirflowInstanceUid() == null) {
            return new Uuid5(Uuid5.NAMESPACE_DBND_JOB, context.getDagId()).toString();
        }
        return new Uuid5(Uuid5.NAMESPACE_DBND_JOB, String.format("%s:%s", context.getAirflowInstanceUid(), context.getDagId())).toString();
    }

    @JsonIgnore
    public String jobName() {
        return String.format("%s.%s", this.dagId, this.taskId);
    }
}

