/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.log;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class HistogramRequest {
    private final Set<String> includeColumns = new HashSet<String>(1);
    private final Set<String> excludeColumns = new HashSet<String>(1);
    private boolean includeAllNumeric;
    private boolean includeAllString;
    private boolean includeAllBoolean;
    private boolean onlyStats;
    private boolean approxDistinct;
    private final boolean enabled;

    public HistogramRequest() {
        this.enabled = true;
    }

    public HistogramRequest(boolean all) {
        this.enabled = all;
        if (all) {
            this.includeAllString = true;
            this.includeAllBoolean = true;
            this.includeAllNumeric = true;
        }
    }

    public HistogramRequest includeColumns(Collection<String> columns) {
        this.includeColumns.addAll(columns);
        return this;
    }

    public HistogramRequest excludeColumns(Collection<String> columns) {
        this.excludeColumns.addAll(columns);
        return this;
    }

    public HistogramRequest includeAllBoolean() {
        this.includeAllBoolean = true;
        return this;
    }

    public HistogramRequest includeAllNumeric() {
        this.includeAllNumeric = true;
        return this;
    }

    public HistogramRequest includeAllString() {
        this.includeAllString = true;
        return this;
    }

    public HistogramRequest onlyStats() {
        this.onlyStats = true;
        return this;
    }

    public HistogramRequest approxDistinct() {
        this.approxDistinct = true;
        return this;
    }

    protected Set<String> getIncludeColumns() {
        return this.includeColumns;
    }

    public Set<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    public boolean isIncludeAllBoolean() {
        return this.includeAllBoolean;
    }

    public boolean isIncludeAllNumeric() {
        return this.includeAllNumeric;
    }

    public boolean isIncludeAllString() {
        return this.includeAllString;
    }

    public boolean isOnlyStats() {
        return this.onlyStats;
    }

    public boolean isApproxDistinct() {
        return this.approxDistinct;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isExcluded(String column) {
        return this.excludeColumns.contains(column);
    }

    public static HistogramRequest ALL() {
        return new HistogramRequest(true);
    }

    public static HistogramRequest ALL_STRING() {
        return new HistogramRequest().includeAllString();
    }

    public static HistogramRequest ALL_BOOLEAN() {
        return new HistogramRequest().includeAllBoolean();
    }

    public static HistogramRequest ALL_NUMERIC() {
        return new HistogramRequest().includeAllNumeric();
    }

    public static HistogramRequest NONE() {
        return new HistogramRequest(false);
    }

    public static HistogramRequest DEFAULT() {
        return HistogramRequest.ALL();
    }
}

