package ai.connectif.sdk.model.customevent

import java.util.Date

sealed class CustomEventValue {
    data class Text(val text: String) : CustomEventValue()
    data class Phone(val number: String) : CustomEventValue()
    data class Email(val email: String) : CustomEventValue()
    data class Integer(val number: Int) : CustomEventValue()
    data class Decimal(val number: Double) : CustomEventValue()
    data class DateTime(val date: Date) : CustomEventValue()
    data class Boolean(val boolean: kotlin.Boolean) : CustomEventValue()
    data class MultipleChoice(val choices: List<String>) : CustomEventValue()
    data class SingleOption(val option: String) : CustomEventValue()
}
