package ai.connectif.sdk.data.source.model.request

import ai.connectif.sdk.data.model.event.DeviceInfo
import ai.connectif.sdk.data.model.event.ProductBasketItemInternal
import java.math.BigDecimal
import java.util.Date

internal data class PurchaseRequest(
    override var deviceInfo: DeviceInfo?,
    val purchase: PurchaseApiModel,
    override val trackerId: String?,
    override val email: String?
) : EventRequest

internal data class PurchaseApiModel(
    val purchaseId: String,
    val products: List<ProductBasketItemInternal>,
    val totalQuantity: Int,
    val totalPrice: BigDecimal,
    val cartId: String? = null,
    val purchaseDate: Date? = null,
    val paymentMethod: String? = null
)
