package ai.connectif.sdk.data.source

import ai.connectif.sdk.data.source.model.request.AddPushTokenRequest
import ai.connectif.sdk.data.source.model.request.CartRequest
import ai.connectif.sdk.data.source.model.request.ContactInfoRequest
import ai.connectif.sdk.data.source.model.request.CustomRequest
import ai.connectif.sdk.data.source.model.request.GetNewTrackerRequest
import ai.connectif.sdk.data.source.model.request.LoginRequest
import ai.connectif.sdk.data.source.model.request.PageVisitRequest
import ai.connectif.sdk.data.source.model.request.ProductVisitRequest
import ai.connectif.sdk.data.source.model.request.PurchaseRequest
import ai.connectif.sdk.data.source.model.request.PushClickRequest
import ai.connectif.sdk.data.source.model.request.PushOpenRequest
import ai.connectif.sdk.data.source.model.request.RegisterRequest
import ai.connectif.sdk.data.source.model.request.SearchRequest
import ai.connectif.sdk.data.source.model.request.SubscribeNewsletterRequest
import ai.connectif.sdk.data.source.model.response.SendEventResponse
import retrofit2.http.Body
import retrofit2.http.Header
import retrofit2.http.Headers
import retrofit2.http.POST

internal interface ConnectifApiService {
    @Headers(
        "Accept: */*",
        "Connection: keep-alive",
        "Content-type: application/json"
    )
    @POST("track/page-visit")
    suspend fun postPageVisit(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: PageVisitRequest
    ): SendEventResponse?

    @POST("track/cart")
    suspend fun postCartProductAdded(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: CartRequest
    ): SendEventResponse?

    @POST("track/login")
    suspend fun postLogin(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: LoginRequest
    ): SendEventResponse?

    @POST("track/register")
    suspend fun postRegister(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: RegisterRequest
    ): SendEventResponse?

    @POST("track/search")
    suspend fun postSearch(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: SearchRequest
    ): SendEventResponse?

    @POST("track/product-visit")
    suspend fun postProductVisit(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: ProductVisitRequest
    ): SendEventResponse?

    @POST("track/contact-info")
    suspend fun postContactInfo(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: ContactInfoRequest
    ): SendEventResponse?

    @POST("track/purchase")
    suspend fun postPurchase(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: PurchaseRequest
    ): SendEventResponse?

    @POST("track/custom")
    suspend fun postCustom(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: CustomRequest
    ): SendEventResponse?

    @POST("track/add-push-token")
    suspend fun postAddPushToken(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: AddPushTokenRequest
    ): SendEventResponse?

    @POST("track/push-click")
    suspend fun postPushClick(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: PushClickRequest
    )

    @POST("track/push-open")
    suspend fun postPushOpen(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: PushOpenRequest
    )

    @POST("track/new-tracker")
    suspend fun postGetNewTracker(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: GetNewTrackerRequest
    ): SendEventResponse?

    @POST("track/subscribe-to-newsletter")
    suspend fun postSubscribeToNewsletter(
        @Header("Authorization") apiKey: String,
        @Header("device-id") deviceID: String,
        @Body body: SubscribeNewsletterRequest
    ): SendEventResponse?
}
