package ai.connectif.sdk.data.model.push

import ai.connectif.sdk.data.model.event.DeviceInfo
import ai.connectif.sdk.data.source.model.request.PushOpenRequest

internal data class TrackPushOpenData(
    var notificationData: NotificationData,
    var trackerId: String? = null,
    var deviceInfo: DeviceInfo? = null
) {
    fun mapToApiModel(): PushOpenRequest {
        return PushOpenRequest(
            deviceInfo = deviceInfo,
            workflowDefinitionId = notificationData.workflowDefinitionId,
            contentId = notificationData.contentId,
            sendUuid = notificationData.sendUuid,
            trackerId = trackerId
        )
    }
}
