package ai.connectif.sdk.data.model.event

import ai.connectif.sdk.data.source.model.request.SearchRequest

internal data class SearchInternal(
    var searchText: String,
    override var trackerId: String? = null,
    override var email: String? = null,
    override var deviceInfo: DeviceInfo? = null
) : Event {
    fun mapToApiModel(): SearchRequest {
        return SearchRequest(
            deviceInfo = deviceInfo,
            this.searchText,
            trackerId = trackerId,
            email = email
        )
    }
}
