package ai.connectif.sdk.data.model.event

import ai.connectif.sdk.data.source.model.request.RegisterRequest
import ai.connectif.sdk.model.RegisterContactInfo

internal data class RegisterInternal(
    override var email: String?,
    override var trackerId: String? = null,
    override var deviceInfo: DeviceInfo? = null,
    var token: String? = null,
    var contactInfo: RegisterContactInfo?
) : Event {
    fun mapToApiModel(): RegisterRequest = RegisterRequest(
        deviceInfo = deviceInfo,
        email = email,
        trackerId = trackerId,
        token = token,
        name = contactInfo?.name,
        surname = contactInfo?.surname,
        birthdate = contactInfo?.birthdate,
        mobilePhone = contactInfo?.mobilePhone,
        newsletterSubscriptionStatus = contactInfo?.newsletterSubscriptionStatus?.value,
        smsSubscriptionStatus = contactInfo?.smsSubscriptionStatus?.value
    )
}
