package ai.connectif.sdk.data.model.event

import ai.connectif.sdk.data.source.model.request.PurchaseApiModel
import ai.connectif.sdk.data.source.model.request.PurchaseRequest
import java.math.BigDecimal
import java.util.Date

internal data class PurchaseInternal(
    val purchaseId: String,
    val products: List<ProductBasketItemInternal>,
    val totalQuantity: Int,
    val totalPrice: BigDecimal,
    val paymentMethod: String?,
    val cartId: String?,
    val purchaseDate: Date?,
    override var trackerId: String? = null,
    override var email: String? = null,
    override var deviceInfo: DeviceInfo? = null
) : Event {
    fun mapToApiModel(): PurchaseRequest = PurchaseRequest(
        deviceInfo = deviceInfo,
        purchase = PurchaseApiModel(
            purchaseId,
            products,
            totalQuantity,
            totalPrice,
            cartId,
            purchaseDate,
            paymentMethod
        ),
        trackerId = trackerId,
        email = email
    )
}
