package ai.connectif.sdk.data.model.event

import ai.connectif.sdk.data.source.model.request.CustomRequest

internal data class CustomInternal(
    val payload: Any,
    val eventId: String? = null,
    val eventAlias: String? = null,
    override var trackerId: String? = null,
    override var email: String? = null,
    override var deviceInfo: DeviceInfo? = null
) : Event {
    init {
        require((eventId != null).xor(eventAlias != null)) {
            "An eventId or eventAlias must be provided, but not both."
        }
    }

    fun mapToApiModel(): CustomRequest {
        return CustomRequest(
            deviceInfo = deviceInfo,
            eventId = this.eventId,
            eventAlias = this.eventAlias,
            payload = this.payload,
            trackerId = this.trackerId,
            email = this.email
        )
    }
}
