package ai.connectif.sdk.data.error

import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import okhttp3.ResponseBody
import retrofit2.HttpException

class ValidationException(val messageErrors: List<String>) : Exception("HTTP Exception") {

    companion object {
        fun fromHttpException(httpException: HttpException): ValidationException {
            val responseBody: ResponseBody? = httpException.response()?.errorBody()

            return if (responseBody != null) {
                try {
                    val errorMap = parseErrorBody(responseBody.string())
                    val messageErrors = errorMap["errors"]
                        ?: listOf("An error occurred, but could not parse the error details.")
                    ValidationException(messageErrors)
                } catch (e: Exception) {
                    ValidationException(
                        listOf("An error occurred, but could not parse the error details.")
                    )
                }
            } else {
                ValidationException(listOf("Unknown error occurred, no details provided."))
            }
        }

        private fun parseErrorBody(errorBodyString: String): Map<String, List<String>> {
            val gson = Gson()
            val type = object : TypeToken<Map<String, List<String>>>() {}.type
            return gson.fromJson(errorBodyString, type)
        }
    }
}
