/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.presenter;

import ai.botbrain.ttcloud.sdk.activity.TsdJieCaoVideoActivity;
import ai.botbrain.ttcloud.sdk.activity.TsdVideoFullscreenActivity;
import ai.botbrain.ttcloud.sdk.activity.TsdVideoPlayActivity;
import ai.botbrain.ttcloud.sdk.model.InjectJsEntity;
import android.content.Context;
import android.content.Intent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsPresenter {
    private List<Pattern> patternList;
    private List<InjectJsEntity.Content> contentList;
    private static JsPresenter instance = null;

    private JsPresenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsPresenter getInstance() {
        Class<JsPresenter> clazz = JsPresenter.class;
        synchronized (JsPresenter.class) {
            if (instance == null) {
                instance = new JsPresenter();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setData(List<InjectJsEntity.Content> contents) {
        this.contentList = contents;
        instance.initPatternList();
    }

    public boolean isEmpty() {
        return null == this.contentList || this.contentList.size() == 0;
    }

    public String getJsByWebAddress(String videoAddress) {
        for (int i = 0; i < this.patternList.size(); ++i) {
            Pattern pattern = this.patternList.get(i);
            boolean isMatches = pattern.matcher(videoAddress).find();
            if (!isMatches) continue;
            return this.contentList.get((int)i).js.replace("%", "%25");
        }
        return "";
    }

    private void initPatternList() {
        this.patternList = new ArrayList<Pattern>();
        if (null == this.contentList || this.contentList.size() == 0) {
            return;
        }
        System.out.println(this.contentList.size());
        for (InjectJsEntity.Content content : this.contentList) {
            String str = content.pattern;
            System.out.println(str);
            Pattern pattern = Pattern.compile(str);
            this.patternList.add(pattern);
        }
    }

    public boolean isUsePlayer(String videoAddress) {
        for (Pattern pattern : this.patternList) {
            boolean isMatches = pattern.matcher(videoAddress).find();
            if (!isMatches) continue;
            return true;
        }
        return false;
    }

    public boolean isUseYoKuPlay(String url) {
        String s = "(.*\\.)?youku\\.com";
        Pattern pattern = Pattern.compile(s);
        Matcher m = pattern.matcher(url.toString());
        return m.find();
    }

    public void openLocalPlayer(Context context, String web_url, String title) {
        Intent i = new Intent();
        i.putExtra("web_url", web_url);
        i.putExtra("title", title);
        i.setClass(context, TsdJieCaoVideoActivity.class);
        context.startActivity(i);
    }

    public void openYoKuPlayer(Context context, String vid, String iid) {
        Intent i = new Intent();
        i.putExtra("vid", vid);
        i.putExtra("iid", iid);
        i.setClass(context, TsdVideoFullscreenActivity.class);
        context.startActivity(i);
    }

    public void openBrowser(Context context, String web_url, String title) {
        Intent movieIntent = new Intent(context, TsdVideoPlayActivity.class);
        movieIntent.putExtra("url", web_url);
        movieIntent.putExtra("title", title);
        context.startActivity(movieIntent);
    }

    public String getYoKuVid(String url) {
        Pattern p = Pattern.compile("(?<=id_).+?(?=.html)");
        Matcher m = p.matcher(url.toString());
        if (m.find()) {
            String vid = m.group(0).trim();
            return vid;
        }
        return "";
    }

    public void StartPlayback(Context context, String webUrl, String title, String iid) {
        if (JsPresenter.getInstance().isUsePlayer(webUrl)) {
            JsPresenter.getInstance().openLocalPlayer(context, webUrl, title);
        } else if (JsPresenter.getInstance().isUseYoKuPlay(webUrl)) {
            String vid = JsPresenter.getInstance().getYoKuVid(webUrl);
            JsPresenter.getInstance().openYoKuPlayer(context, vid, iid);
        } else {
            JsPresenter.getInstance().openBrowser(context, webUrl, title);
        }
    }

    public boolean isQYVideo(String webPageAddress) {
        if (null == webPageAddress || webPageAddress.equals("")) {
            return false;
        }
        Pattern p1 = Pattern.compile("(.*\\.)?iqiyi\\.com");
        boolean isMatches = p1.matcher(webPageAddress).find();
        return isMatches;
    }

    public boolean isSHVideo(String webPageAddress) {
        if (null == webPageAddress || webPageAddress.equals("")) {
            return false;
        }
        Pattern p1 = Pattern.compile("(.*\\.)?tv\\.sohu\\.com");
        Pattern p2 = Pattern.compile("(.*\\.)?live\\.tv\\.sohu\\.com");
        Pattern p3 = Pattern.compile("(.*\\.)?live\\.tv\\.sohu\\.com");
        boolean isMatches1 = p1.matcher(webPageAddress).find();
        boolean isMatches2 = p2.matcher(webPageAddress).find();
        return isMatches1 || isMatches2;
    }
}

