/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.presenter;

import ai.botbrain.ttcloud.sdk.util.LogUtil;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Base64;
import com.google.gson.Gson;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class AppsListPresenter {
    private static final String TAG = AppsListPresenter.class.getSimpleName();
    private final Context mContext;
    private Gson gson;
    private SPUtils spUtils;
    private MD5 md5;
    private static AppsListPresenter MY_INSTANCE = null;
    private List<String> temp_appNames;
    private ArrayList<AppInfo> temp_appInfos;
    private static final int MSG_SUCCESS = 1;
    private static final String SP_APP_LIST = "app_list";
    private static final String BASE_URL = "https://log.firedata.cc/log/v2/FDU5D2P34/app_list?data=";
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AppsListPresenter.this.sendMessageHttp();
                }
            }
        }
    };
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            AppsListPresenter.this.temp_appInfos = AppsListPresenter.this.getInstallApkInfo();
            if (AppsListPresenter.this.isChanged()) {
                AppsListPresenter.this.mHandler.sendEmptyMessage(1);
                LogUtil.i(TAG, "\u53d8\u52a8\u4e86");
            } else {
                LogUtil.i(TAG, "\u6ca1\u6709\u53d8\u5316");
            }
        }
    };

    private AppsListPresenter(Context context) {
        this.mContext = context;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void upload(Context context) {
        if (MY_INSTANCE != null) return;
        Class<AppsListPresenter> clazz = AppsListPresenter.class;
        synchronized (AppsListPresenter.class) {
            if (MY_INSTANCE != null) return;
            MY_INSTANCE = new AppsListPresenter(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void init() {
        this.spUtils = new SPUtils();
        this.temp_appNames = new ArrayList<String>();
        this.md5 = new MD5();
        this.gson = new Gson();
        Thread mThread = new Thread(this.runnable);
        mThread.start();
    }

    private void saveData() {
        String str = this.gson.toJson(this.temp_appNames);
        String enToStr = null;
        try {
            enToStr = this.md5.getMD5(str);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        this.spUtils.put(this.mContext, SP_APP_LIST, enToStr);
    }

    private boolean isChanged() {
        String json_apps = (String)this.spUtils.get(this.mContext, SP_APP_LIST, "");
        String str = null;
        try {
            str = this.md5.getMD5(this.gson.toJson(this.temp_appNames));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null == str || !str.equals(json_apps);
    }

    public ArrayList<AppInfo> getInstallApkInfo() {
        long startTime = System.currentTimeMillis();
        this.temp_appNames = new ArrayList<String>();
        this.temp_appInfos = new ArrayList();
        PackageManager pm = this.mContext.getPackageManager();
        List list = pm.getInstalledPackages(0);
        for (PackageInfo packageInfo : list) {
            AppInfo appInfo = new AppInfo();
            appInfo.name = packageInfo.applicationInfo.loadLabel(pm).toString();
            appInfo.pakg = packageInfo.applicationInfo.packageName;
            appInfo.ftime = String.valueOf(packageInfo.firstInstallTime);
            appInfo.ver = packageInfo.versionName;
            appInfo.proc = packageInfo.applicationInfo.processName;
            if ((packageInfo.applicationInfo.flags & 1) == 0) {
                appInfo.type = "1";
                LogUtil.i(TAG, "\u975e\u7cfb\u7edf\u5e94\u7528" + appInfo.name);
                this.temp_appNames.add(appInfo.pakg + appInfo.ver);
                this.temp_appInfos.add(appInfo);
                continue;
            }
            LogUtil.i(TAG, "\u7cfb\u7edf\u5e94\u7528\uff1a" + appInfo.name);
            appInfo.type = "0";
        }
        long endTime = System.currentTimeMillis();
        LogUtil.i(TAG, "time\uff1a " + (endTime - startTime) + "ms");
        return this.temp_appInfos;
    }

    private String generateJson(String sdk_ver, String time, String imei, String mac, String apps) {
        try {
            apps = URLEncoder.encode(apps, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String str = "sdk_ver=" + sdk_ver + "&" + "time=" + time + "&" + "imei=" + imei + "&" + "mac=" + mac + "&" + "apps=" + apps;
        LogUtil.i(TAG, str);
        return Base64.encodeToString((byte[])str.trim().getBytes(), (int)2);
    }

    private String getHttpUrl() {
        DeviceUtils du = new DeviceUtils();
        Data mData = new Data();
        mData.imei = du.getIMEI(this.mContext);
        mData.time = String.valueOf(System.currentTimeMillis());
        mData.apps = this.temp_appInfos;
        mData.mac = du.getMacAddress(this.mContext);
        String str_apps = this.gson.toJson(mData.apps);
        LogUtil.i(TAG, "" + str_apps);
        String httpUrl = BASE_URL + this.generateJson(du.getVersion(this.mContext), mData.time, mData.imei, mData.mac, str_apps);
        return httpUrl;
    }

    private void sendMessageHttp() {
        String url = this.getHttpUrl();
    }

    private class MD5 {
        private MD5() {
        }

        private String getMD5(String val) throws NoSuchAlgorithmException {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(val.getBytes());
            byte[] m = md5.digest();
            return this.getString(m);
        }

        private String getString(byte[] b) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < b.length; ++i) {
                sb.append(b[i]);
            }
            return sb.toString();
        }
    }

    class SharedPreferencesCompat {
        private final Method sApplyMethod = this.findApplyMethod();

        SharedPreferencesCompat() {
        }

        private Method findApplyMethod() {
            try {
                Class<SharedPreferences.Editor> clz = SharedPreferences.Editor.class;
                return clz.getMethod("apply", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }

        public void apply(SharedPreferences.Editor editor) {
            try {
                if (this.sApplyMethod != null) {
                    this.sApplyMethod.invoke((Object)editor, new Object[0]);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            editor.commit();
        }
    }

    class SPUtils {
        private SharedPreferencesCompat sfc;
        public final String FILE_NAME = "app_list";

        public SPUtils() {
            this.sfc = new SharedPreferencesCompat();
            this.FILE_NAME = AppsListPresenter.SP_APP_LIST;
        }

        public void put(Context context, String key, Object object) {
            SharedPreferences sp = context.getSharedPreferences(AppsListPresenter.SP_APP_LIST, 0);
            SharedPreferences.Editor editor = sp.edit();
            if (object instanceof String) {
                editor.putString(key, (String)object);
            } else if (object instanceof Integer) {
                editor.putInt(key, ((Integer)object).intValue());
            } else if (object instanceof Boolean) {
                editor.putBoolean(key, ((Boolean)object).booleanValue());
            } else if (object instanceof Float) {
                editor.putFloat(key, ((Float)object).floatValue());
            } else if (object instanceof Long) {
                editor.putLong(key, ((Long)object).longValue());
            } else {
                editor.putString(key, object.toString());
            }
            this.sfc.apply(editor);
        }

        public Object get(Context context, String key, Object defaultObject) {
            SharedPreferences sp = context.getSharedPreferences(AppsListPresenter.SP_APP_LIST, 0);
            if (defaultObject instanceof String) {
                return sp.getString(key, (String)defaultObject);
            }
            if (defaultObject instanceof Integer) {
                return sp.getInt(key, ((Integer)defaultObject).intValue());
            }
            if (defaultObject instanceof Boolean) {
                return sp.getBoolean(key, ((Boolean)defaultObject).booleanValue());
            }
            if (defaultObject instanceof Float) {
                return Float.valueOf(sp.getFloat(key, ((Float)defaultObject).floatValue()));
            }
            if (defaultObject instanceof Long) {
                return sp.getLong(key, ((Long)defaultObject).longValue());
            }
            return null;
        }

        public void remove(Context context, String key) {
            SharedPreferences sp = context.getSharedPreferences(AppsListPresenter.SP_APP_LIST, 0);
            SharedPreferences.Editor editor = sp.edit();
            editor.remove(key);
            this.sfc.apply(editor);
        }

        public void clear(Context context) {
            SharedPreferences sp = context.getSharedPreferences(AppsListPresenter.SP_APP_LIST, 0);
            SharedPreferences.Editor editor = sp.edit();
            editor.clear();
            this.sfc.apply(editor);
        }

        public boolean contains(Context context, String key) {
            SharedPreferences sp = context.getSharedPreferences(AppsListPresenter.SP_APP_LIST, 0);
            return sp.contains(key);
        }

        public Map<String, ?> getAll(Context context) {
            SharedPreferences sp = context.getSharedPreferences(AppsListPresenter.SP_APP_LIST, 0);
            return sp.getAll();
        }
    }

    class AppInfo
    implements Serializable {
        public String name;
        public String pakg;
        public String proc;
        public String ftime;
        public String ver;
        public String type;

        AppInfo() {
        }
    }

    class DeviceUtils {
        DeviceUtils() {
        }

        public String getMacAddress(Context context) {
            String macAddress = null;
            try {
                String wifiInterfaceName = "wlan0";
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface iF = interfaces.nextElement();
                    if (!iF.getName().equalsIgnoreCase(wifiInterfaceName)) continue;
                    byte[] addr = iF.getHardwareAddress();
                    if (addr == null || addr.length == 0) {
                        return null;
                    }
                    StringBuilder buf = new StringBuilder();
                    for (byte b : addr) {
                        buf.append(String.format("%02X:", b));
                    }
                    if (buf.length() > 0) {
                        buf.deleteCharAt(buf.length() - 1);
                    }
                    macAddress = buf.toString();
                    break;
                }
            }
            catch (SocketException se) {
                macAddress = null;
            }
            if (TextUtils.isEmpty(macAddress)) {
                WifiManager wifi = (WifiManager)context.getApplicationContext().getSystemService("wifi");
                macAddress = wifi.getConnectionInfo().getMacAddress();
            }
            return macAddress;
        }

        public String getIMEI(Context context) {
            String deviceId = "";
            return deviceId;
        }

        public String getVersion(Context context) {
            try {
                PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                return pi.versionName;
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
                return "unknow";
            }
        }
    }

    class Data {
        public String imei;
        public String time;
        public String mac;
        public String sdk_ver;
        public List<AppInfo> apps;

        Data() {
        }
    }
}

