/*
 * Decompiled with CFR 0.152.
 */
package ai.botbrain.ttcloud.sdk.banner;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.banner.BannerScroller;
import ai.botbrain.ttcloud.sdk.banner.WeakHandler;
import ai.botbrain.ttcloud.sdk.banner.listener.OnBannerClickListener;
import ai.botbrain.ttcloud.sdk.banner.listener.OnBannerListener;
import ai.botbrain.ttcloud.sdk.banner.loader.ImageLoaderInterface;
import ai.botbrain.ttcloud.sdk.banner.view.BannerViewPager;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class Banner
extends FrameLayout
implements ViewPager.OnPageChangeListener {
    public String tag = "banner";
    private int mIndicatorMargin = 5;
    private int mIndicatorWidth;
    private int mIndicatorHeight;
    private int indicatorSize;
    private int bannerStyle = 1;
    private int delayTime = 2000;
    private int scrollTime = 800;
    private boolean isAutoPlay = true;
    private boolean isScroll = true;
    private int mIndicatorSelectedResId = R.drawable.gray_radius;
    private int mIndicatorUnselectedResId = R.drawable.white_radius;
    private int mLayoutResId = R.layout.banner;
    private int titleHeight;
    private int titleBackground;
    private int titleTextColor;
    private int titleTextSize;
    private int count = 0;
    private int currentItem;
    private int gravity = -1;
    private int lastPosition = 1;
    private int scaleType = 1;
    private List<String> titles;
    private List imageUrls;
    private List<View> imageViews;
    private List<ImageView> indicatorImages;
    private Context context;
    private BannerViewPager viewPager;
    private TextView bannerTitle;
    private TextView numIndicatorInside;
    private TextView numIndicator;
    private LinearLayout indicator;
    private LinearLayout indicatorInside;
    private LinearLayout titleView;
    private ImageLoaderInterface imageLoader;
    private BannerPagerAdapter adapter;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private BannerScroller mScroller;
    private OnBannerClickListener bannerListener;
    private OnBannerListener listener;
    private DisplayMetrics dm;
    private WeakHandler handler = new WeakHandler();
    private final Runnable task = new Runnable(){

        @Override
        public void run() {
            if (Banner.this.count > 1 && Banner.this.isAutoPlay) {
                Banner.this.currentItem = Banner.this.currentItem % (Banner.this.count + 1) + 1;
                if (Banner.this.currentItem == 1) {
                    Banner.this.viewPager.setCurrentItem(Banner.this.currentItem, false);
                    Banner.this.handler.post(Banner.this.task);
                } else {
                    Banner.this.viewPager.setCurrentItem(Banner.this.currentItem);
                    Banner.this.handler.postDelayed(Banner.this.task, Banner.this.delayTime);
                }
            }
        }
    };

    public Banner(Context context) {
        this(context, null);
    }

    public Banner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Banner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.titles = new ArrayList<String>();
        this.imageUrls = new ArrayList();
        this.imageViews = new ArrayList<View>();
        this.indicatorImages = new ArrayList<ImageView>();
        this.dm = context.getResources().getDisplayMetrics();
        this.indicatorSize = this.dm.widthPixels / 80;
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.imageViews.clear();
        this.handleTypedArray(context, attrs);
        View view = LayoutInflater.from((Context)context).inflate(this.mLayoutResId, (ViewGroup)this, true);
        this.viewPager = (BannerViewPager)view.findViewById(R.id.bannerViewPager);
        this.titleView = (LinearLayout)view.findViewById(R.id.titleView);
        this.indicator = (LinearLayout)view.findViewById(R.id.circleIndicator);
        this.indicatorInside = (LinearLayout)view.findViewById(R.id.indicatorInside);
        this.bannerTitle = (TextView)view.findViewById(R.id.bannerTitle);
        this.numIndicator = (TextView)view.findViewById(R.id.numIndicator);
        this.numIndicatorInside = (TextView)view.findViewById(R.id.numIndicatorInside);
        this.initViewPagerScroll();
    }

    private void handleTypedArray(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.tsd_banner);
        this.mIndicatorWidth = typedArray.getDimensionPixelSize(R.styleable.tsd_banner_indicator_width, this.indicatorSize);
        this.mIndicatorHeight = typedArray.getDimensionPixelSize(R.styleable.tsd_banner_indicator_height, this.indicatorSize);
        this.mIndicatorMargin = typedArray.getDimensionPixelSize(R.styleable.tsd_banner_indicator_margin, 5);
        this.mIndicatorSelectedResId = typedArray.getResourceId(R.styleable.tsd_banner_indicator_drawable_selected, R.drawable.gray_radius);
        this.mIndicatorUnselectedResId = typedArray.getResourceId(R.styleable.tsd_banner_indicator_drawable_unselected, R.drawable.white_radius);
        this.scaleType = typedArray.getInt(R.styleable.tsd_banner_image_scale_type, this.scaleType);
        this.delayTime = typedArray.getInt(R.styleable.tsd_banner_delay_time, 2000);
        this.scrollTime = typedArray.getInt(R.styleable.tsd_banner_scroll_time, 800);
        this.isAutoPlay = typedArray.getBoolean(R.styleable.tsd_banner_is_auto_play, true);
        this.titleBackground = typedArray.getColor(R.styleable.tsd_banner_title_background, -1);
        this.titleHeight = typedArray.getDimensionPixelSize(R.styleable.tsd_banner_title_height, -1);
        this.titleTextColor = typedArray.getColor(R.styleable.tsd_banner_title_textcolor, -1);
        this.titleTextSize = typedArray.getDimensionPixelSize(R.styleable.tsd_banner_title_textsize, -1);
        this.mLayoutResId = typedArray.getResourceId(R.styleable.tsd_banner_layout_id, this.mLayoutResId);
        typedArray.recycle();
    }

    private void initViewPagerScroll() {
        try {
            Field mField = ViewPager.class.getDeclaredField("mScroller");
            mField.setAccessible(true);
            this.mScroller = new BannerScroller(this.viewPager.getContext());
            this.mScroller.setDuration(this.scrollTime);
            mField.set((Object)this.viewPager, (Object)this.mScroller);
        }
        catch (Exception e) {
            Log.e((String)this.tag, (String)e.getMessage());
        }
    }

    public Banner isAutoPlay(boolean isAutoPlay) {
        this.isAutoPlay = isAutoPlay;
        return this;
    }

    public Banner setImageLoader(ImageLoaderInterface imageLoader) {
        this.imageLoader = imageLoader;
        return this;
    }

    public Banner setDelayTime(int delayTime) {
        this.delayTime = delayTime;
        return this;
    }

    public Banner setIndicatorGravity(int type) {
        switch (type) {
            case 5: {
                this.gravity = 19;
                break;
            }
            case 6: {
                this.gravity = 17;
                break;
            }
            case 7: {
                this.gravity = 21;
            }
        }
        return this;
    }

    public Banner setBannerAnimation(Class<? extends ViewPager.PageTransformer> transformer) {
        try {
            this.setPageTransformer(true, transformer.newInstance());
        }
        catch (Exception e) {
            Log.e((String)this.tag, (String)"Please set the PageTransformer class");
        }
        return this;
    }

    public Banner setOffscreenPageLimit(int limit) {
        if (this.viewPager != null) {
            this.viewPager.setOffscreenPageLimit(limit);
        }
        return this;
    }

    public Banner setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        this.viewPager.setPageTransformer(reverseDrawingOrder, transformer);
        return this;
    }

    public Banner setBannerTitles(List<String> titles) {
        this.titles = titles;
        return this;
    }

    public Banner setBannerStyle(int bannerStyle) {
        this.bannerStyle = bannerStyle;
        return this;
    }

    public Banner setViewPagerIsScroll(boolean isScroll) {
        this.isScroll = isScroll;
        return this;
    }

    public Banner setImages(List<?> imageUrls) {
        this.imageUrls = imageUrls;
        this.count = imageUrls.size();
        return this;
    }

    public void update(List<?> imageUrls, List<String> titles) {
        this.imageUrls.clear();
        this.titles.clear();
        this.imageUrls.addAll(imageUrls);
        this.titles.addAll(titles);
        this.count = this.imageUrls.size();
        this.start();
    }

    public void update(List<?> imageUrls) {
        this.imageUrls.clear();
        this.imageUrls.addAll(imageUrls);
        this.count = this.imageUrls.size();
        this.start();
    }

    public void updateBannerStyle(int bannerStyle) {
        this.indicator.setVisibility(8);
        this.numIndicator.setVisibility(8);
        this.numIndicatorInside.setVisibility(8);
        this.indicatorInside.setVisibility(8);
        this.bannerTitle.setVisibility(8);
        this.titleView.setVisibility(8);
        this.bannerStyle = bannerStyle;
        this.start();
    }

    public Banner start() {
        this.setBannerStyleUI();
        this.setImageList(this.imageUrls);
        this.setData();
        return this;
    }

    private void setTitleStyleUI() {
        if (this.titles.size() != this.imageUrls.size()) {
            throw new RuntimeException("[Banner] --> The number of titles and images is different");
        }
        if (this.titleBackground != -1) {
            this.titleView.setBackgroundColor(this.titleBackground);
        }
        if (this.titleHeight != -1) {
            this.titleView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.titleHeight));
        }
        if (this.titleTextColor != -1) {
            this.bannerTitle.setTextColor(this.titleTextColor);
        }
        if (this.titleTextSize != -1) {
            this.bannerTitle.setTextSize(0, (float)this.titleTextSize);
        }
        if (this.titles != null && this.titles.size() > 0) {
            this.bannerTitle.setText((CharSequence)this.titles.get(0));
            this.bannerTitle.setVisibility(0);
            this.titleView.setVisibility(0);
        }
    }

    private void setBannerStyleUI() {
        int visibility = this.count > 1 ? 0 : 8;
        switch (this.bannerStyle) {
            case 1: {
                this.indicator.setVisibility(visibility);
                break;
            }
            case 2: {
                this.numIndicator.setVisibility(visibility);
                break;
            }
            case 3: {
                this.numIndicatorInside.setVisibility(visibility);
                this.setTitleStyleUI();
                break;
            }
            case 4: {
                this.indicator.setVisibility(visibility);
                this.setTitleStyleUI();
                break;
            }
            case 5: {
                this.indicatorInside.setVisibility(visibility);
                this.setTitleStyleUI();
            }
        }
    }

    private void initImages() {
        this.imageViews.clear();
        if (this.bannerStyle == 1 || this.bannerStyle == 4 || this.bannerStyle == 5) {
            this.createIndicator();
        } else if (this.bannerStyle == 3) {
            this.numIndicatorInside.setText((CharSequence)("1/" + this.count));
        } else if (this.bannerStyle == 2) {
            this.numIndicator.setText((CharSequence)("1/" + this.count));
        }
    }

    private void setImageList(List<?> imagesUrl) {
        if (imagesUrl == null || imagesUrl.size() <= 0) {
            Log.e((String)this.tag, (String)"Please set the images data.");
            return;
        }
        this.initImages();
        for (int i = 0; i <= this.count + 1; ++i) {
            ImageView imageView = null;
            if (this.imageLoader != null) {
                imageView = (ImageView)this.imageLoader.createImageView(this.context);
            }
            if (imageView == null) {
                imageView = new ImageView(this.context);
            }
            this.setScaleType((View)imageView);
            Object url = null;
            url = i == 0 ? imagesUrl.get(this.count - 1) : (i == this.count + 1 ? imagesUrl.get(0) : imagesUrl.get(i - 1));
            this.imageViews.add((View)imageView);
            if (this.imageLoader != null) {
                this.imageLoader.displayImage(this.context, url, imageView);
                continue;
            }
            Log.e((String)this.tag, (String)"Please set images loader.");
        }
    }

    private void setScaleType(View imageView) {
        if (imageView instanceof ImageView) {
            ImageView view = (ImageView)imageView;
            switch (this.scaleType) {
                case 0: {
                    view.setScaleType(ImageView.ScaleType.CENTER);
                    break;
                }
                case 1: {
                    view.setScaleType(ImageView.ScaleType.CENTER_CROP);
                    break;
                }
                case 2: {
                    view.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    break;
                }
                case 3: {
                    view.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    break;
                }
                case 4: {
                    view.setScaleType(ImageView.ScaleType.FIT_END);
                    break;
                }
                case 5: {
                    view.setScaleType(ImageView.ScaleType.FIT_START);
                    break;
                }
                case 6: {
                    view.setScaleType(ImageView.ScaleType.FIT_XY);
                    break;
                }
                case 7: {
                    view.setScaleType(ImageView.ScaleType.MATRIX);
                }
            }
        }
    }

    private void createIndicator() {
        this.indicatorImages.clear();
        this.indicator.removeAllViews();
        this.indicatorInside.removeAllViews();
        for (int i = 0; i < this.count; ++i) {
            ImageView imageView = new ImageView(this.context);
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.mIndicatorWidth, this.mIndicatorHeight);
            params.leftMargin = this.mIndicatorMargin;
            params.rightMargin = this.mIndicatorMargin;
            if (i == 0) {
                imageView.setImageResource(this.mIndicatorSelectedResId);
            } else {
                imageView.setImageResource(this.mIndicatorUnselectedResId);
            }
            this.indicatorImages.add(imageView);
            if (this.bannerStyle == 1 || this.bannerStyle == 4) {
                this.indicator.addView((View)imageView, (ViewGroup.LayoutParams)params);
                continue;
            }
            if (this.bannerStyle != 5) continue;
            this.indicatorInside.addView((View)imageView, (ViewGroup.LayoutParams)params);
        }
    }

    private void setData() {
        this.currentItem = 1;
        if (this.adapter == null) {
            this.adapter = new BannerPagerAdapter();
            this.viewPager.addOnPageChangeListener(this);
        }
        this.viewPager.setAdapter(this.adapter);
        this.viewPager.setFocusable(true);
        this.viewPager.setCurrentItem(1);
        if (this.gravity != -1) {
            this.indicator.setGravity(this.gravity);
        }
        if (this.isScroll && this.count > 1) {
            this.viewPager.setScrollable(true);
        } else {
            this.viewPager.setScrollable(false);
        }
        if (this.isAutoPlay) {
            this.startAutoPlay();
        }
    }

    public void startAutoPlay() {
        this.handler.removeCallbacks(this.task);
        this.handler.postDelayed(this.task, this.delayTime);
    }

    public void stopAutoPlay() {
        this.handler.removeCallbacks(this.task);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.isAutoPlay) {
            int action = ev.getAction();
            if (action == 1 || action == 3 || action == 4) {
                this.startAutoPlay();
            } else if (action == 0) {
                this.stopAutoPlay();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public int toRealPosition(int position) {
        int realPosition = (position - 1) % this.count;
        if (realPosition < 0) {
            realPosition += this.count;
        }
        return realPosition;
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(state);
        }
        this.currentItem = this.viewPager.getCurrentItem();
        switch (state) {
            case 0: {
                if (this.currentItem == 0) {
                    this.viewPager.setCurrentItem(this.count, false);
                    break;
                }
                if (this.currentItem != this.count + 1) break;
                this.viewPager.setCurrentItem(1, false);
                break;
            }
            case 1: {
                if (this.currentItem == this.count + 1) {
                    this.viewPager.setCurrentItem(1, false);
                    break;
                }
                if (this.currentItem != 0) break;
                this.viewPager.setCurrentItem(this.count, false);
                break;
            }
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(position);
        }
        if (this.bannerStyle == 1 || this.bannerStyle == 4 || this.bannerStyle == 5) {
            this.indicatorImages.get((this.lastPosition - 1 + this.count) % this.count).setImageResource(this.mIndicatorUnselectedResId);
            this.indicatorImages.get((position - 1 + this.count) % this.count).setImageResource(this.mIndicatorSelectedResId);
            this.lastPosition = position;
        }
        if (position == 0) {
            position = this.count;
        }
        if (position > this.count) {
            position = 1;
        }
        switch (this.bannerStyle) {
            case 1: {
                break;
            }
            case 2: {
                this.numIndicator.setText((CharSequence)(position + "/" + this.count));
                break;
            }
            case 3: {
                this.numIndicatorInside.setText((CharSequence)(position + "/" + this.count));
                this.bannerTitle.setText((CharSequence)this.titles.get(position - 1));
                break;
            }
            case 4: {
                this.bannerTitle.setText((CharSequence)this.titles.get(position - 1));
                break;
            }
            case 5: {
                this.bannerTitle.setText((CharSequence)this.titles.get(position - 1));
            }
        }
    }

    @Deprecated
    public Banner setOnBannerClickListener(OnBannerClickListener listener) {
        this.bannerListener = listener;
        return this;
    }

    public Banner setOnBannerListener(OnBannerListener listener) {
        this.listener = listener;
        return this;
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public void releaseBanner() {
        this.handler.removeCallbacksAndMessages(null);
    }

    class BannerPagerAdapter
    extends PagerAdapter {
        BannerPagerAdapter() {
        }

        public int getCount() {
            return Banner.this.imageViews.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, final int position) {
            container.addView((View)Banner.this.imageViews.get(position));
            View view = (View)Banner.this.imageViews.get(position);
            if (Banner.this.bannerListener != null) {
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Log.e((String)Banner.this.tag, (String)"\u4f60\u6b63\u5728\u4f7f\u7528\u65e7\u7248\u70b9\u51fb\u4e8b\u4ef6\u63a5\u53e3\uff0c\u4e0b\u6807\u662f\u4ece1\u5f00\u59cb\uff0c\u4e3a\u4e86\u4f53\u9a8c\u8bf7\u66f4\u6362\u4e3asetOnBannerListener\uff0c\u4e0b\u6807\u4ece0\u5f00\u59cb\u8ba1\u7b97");
                        Banner.this.bannerListener.OnBannerClick(position);
                    }
                });
            }
            if (Banner.this.listener != null) {
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Banner.this.listener.OnBannerClick(Banner.this.toRealPosition(position));
                    }
                });
            }
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }
    }
}

