/*
 * Decompiled with CFR 0.152.
 */
package com.firedata.sdk;

import android.os.Handler;
import android.os.HandlerThread;
import com.firedata.sdk.tools.Logy;

public class WorkerThread
extends HandlerThread {
    private Handler handler;

    public WorkerThread(String name) {
        super(name);
    }

    Handler getHandler() {
        return this.handler;
    }

    void post(Runnable r) {
        this.waitForInitialization();
        this.handler.post(r);
    }

    void postDelayed(Runnable r, long delayMillis) {
        this.waitForInitialization();
        this.handler.postDelayed(r, delayMillis);
    }

    void removeCallbacks(Runnable r) {
        this.waitForInitialization();
        this.handler.removeCallbacks(r);
    }

    private synchronized void waitForInitialization() {
        if (this.handler == null) {
            this.handler = new Handler(this.getLooper());
            this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable ex) {
                    Logy.e("WORKER", "in thread:" + WorkerThread.this.getName(), ex);
                }
            });
        }
    }
}

