/*
 * Decompiled with CFR 0.152.
 */
package com.firedata.sdk;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.os.Build;
import android.text.TextUtils;
import com.firedata.sdk.DatabaseHelper;
import com.firedata.sdk.FiredataCallbacks;
import com.firedata.sdk.PageInfo;
import com.firedata.sdk.Props;
import com.firedata.sdk.WorkerThread;
import com.firedata.sdk.tools.DeviceInfo;
import com.firedata.sdk.tools.Logy;
import com.firedata.sdk.tools.MD5;
import com.firedata.sdk.tools.Utils;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.request.GetRequest;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Tracker {
    public static final String TAG = "com.firedata.tracker";
    public static final String START_SESSION_EVENT = "session_start";
    public static final String END_SESSION_EVENT = "session_end";
    public static final String REVENUE_EVENT = "revenue_amount";
    public static final String GUID_KEY = "guid_id";
    public static final String GUID_INFO = "guid_info";
    public static final String SEQUENCE_NUMBER_KEY = "sequence_number";
    private static final int[] CONFIG_URL_PREFIX = new int[]{104, 116, 116, 112, 58, 47, 47, 115, 100, 107, 46, 102, 105, 114, 101, 100, 97, 116, 97, 46, 99, 99, 47, 115, 100, 107, 47, 97, 110, 47};
    private static final int[] CONFIG_URL_POSTFIX = new int[]{46, 106, 115, 111, 110};
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected static Tracker instance = new Tracker();
    private HashSet<Long> uploading = new HashSet();
    protected Context context;
    private String confhost = null;
    protected String guid;
    private String customGUID;
    protected long guidts = System.currentTimeMillis();
    protected long guidvc = 1L;
    protected long guidlvts = 0L;
    private boolean newDeviceIdPerInstall = false;
    private boolean initialized = false;
    private long lastExitForegroundTime = 0L;
    private int sendErrCount = 0;
    private String appKey;
    private String channel;
    private String abVersion;
    private String userId;
    private ConcurrentHashMap<String, Object> userVars = new ConcurrentHashMap();
    private Map<String, Object> configFromServer = new HashMap<String, Object>();
    private Stack<PageInfo> pvStack = new Stack();
    private DeviceInfo deviceInfo;
    private long sessionId = -1L;
    private int eventUploadThreshold = 10;
    private int eventUploadMaxBatchSize = 10;
    private int eventMaxCount = 200;
    private long eventUploadPeriodMillis = 10000L;
    private long sessionTimeoutMillis = 1800000L;
    private boolean trackingSessionEvents = false;
    private boolean inForeground = false;
    private AtomicBoolean updateScheduled = new AtomicBoolean(false);
    AtomicBoolean uploadingCurrently = new AtomicBoolean(false);
    Throwable lastError;
    WorkerThread logThread = new WorkerThread("logThread");
    WorkerThread httpThread = new WorkerThread("httpThread");
    private boolean debug = false;

    public static Tracker getInstance() {
        return instance;
    }

    public Tracker() {
        this.logThread.start();
        this.httpThread.start();
    }

    public void setConfHost(String host) {
        this.confhost = host;
    }

    public void setCustomGUID(String guid) {
        this.customGUID = guid;
    }

    public Tracker init(Context context, String appKey) {
        return this.init(context, appKey, null);
    }

    public void setABTest(String abVer) {
        this.abVersion = "".equals(abVer) ? null : abVer;
    }

    public synchronized Tracker init(Context context, String appKey, String channel) {
        if (context == null) {
            Logy.e(TAG, "Argument context cannot be null in initialize()");
            throw new IllegalArgumentException("Argument context cannot be null in init()");
        }
        if (TextUtils.isEmpty((CharSequence)appKey)) {
            Logy.e(TAG, "Argument appKey cannot be null or blank in initialize()");
            throw new IllegalArgumentException("Argument appKey cannot be null or blank in init()");
        }
        if (!this.initialized) {
            this.appKey = appKey;
            this.channel = channel;
            this.context = context;
            this.reloadInfo();
            this.initializeDeviceInfo();
            long previousSessionId = this.getPreviousSessionId();
            if (previousSessionId >= 0L) {
                this.sessionId = previousSessionId;
            } else {
                this.startNewSession(System.currentTimeMillis());
            }
            this.initialized = true;
        }
        return instance;
    }

    private void initializeDeviceInfo() {
        this.deviceInfo = new DeviceInfo(this.context);
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Tracker.this.deviceInfo.prefetch();
                    Tracker.this.initializeGUID();
                    Tracker.this.logEvent("/app", "open");
                    Tracker.this.uploadEvents();
                }
                catch (Throwable t) {
                    Logy.e(Tracker.TAG, "error in initializeDeviceInfo", t);
                }
            }
        });
        this.startLoadSrvConfig();
        this.reconfig();
    }

    private void reloadInfo() {
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        this.userId = preferences.getString("com.firedata.sdk.userId", null);
        this.userVars = Utils.jsonToMap(preferences.getString("fd_uvar", "{}"));
        this.configFromServer = Utils.jsonToMap(preferences.getString("fd_config_srv", "{}"));
    }

    private void startLoadSrvConfig() {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                Logy.d(Tracker.TAG, "start load srv Config");
                StringBuffer sb = new StringBuffer();
                if (Tracker.this.confhost != null) {
                    sb.append("http://").append(Tracker.this.confhost).append("/sdk/an/");
                } else {
                    for (int i : CONFIG_URL_PREFIX) {
                        sb.append((char)i);
                    }
                }
                sb.append(Tracker.this.appKey);
                for (int i : CONFIG_URL_POSTFIX) {
                    sb.append((char)i);
                }
                int retries = 0;
                boolean succeeded = false;
                while (retries < 3 && !succeeded) {
                    ++retries;
                    try {
                        Response response = ((GetRequest)((GetRequest)OkGo.get((String)sb.toString()).tag((Object)this)).headers("guid", Tracker.this.guid + "")).execute();
                        String json = response.body().string();
                        Tracker.this.configFromServer = Utils.jsonToMap(json);
                        SharedPreferences preferences = Tracker.this.context.getSharedPreferences(Tracker.this.getSharedPreferencesName(), 0);
                        preferences.edit().putString("fd_config_srv", json).commit();
                        succeeded = true;
                    }
                    catch (IOException e) {
                        Logy.w(Tracker.TAG, "load srv Config Exception: " + e.getMessage());
                    }
                    catch (Exception e) {
                        Logy.w(Tracker.TAG, "load srv Config Exception: " + e.getMessage());
                    }
                }
            }
        });
    }

    private void reconfig() {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                Tracker.this.eventMaxCount = (Integer)Tracker.this.getConfigParam("max_event_count", Tracker.this.eventMaxCount);
                Tracker.this.eventUploadMaxBatchSize = (Integer)Tracker.this.getConfigParam("event_upload_batch", Tracker.this.eventUploadMaxBatchSize);
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    public Tracker enableForegroundTracking(Application app) {
        if (Build.VERSION.SDK_INT >= 14) {
            app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new FiredataCallbacks(instance));
        }
        return instance;
    }

    public Tracker enableLocationListening() {
        if (this.deviceInfo == null) {
            throw new IllegalStateException("Must initialize before acting on location listening.");
        }
        this.deviceInfo.setLocationListening(true);
        return instance;
    }

    public Tracker disableLocationListening() {
        if (this.deviceInfo == null) {
            throw new IllegalStateException("Must initialize before acting on location listening.");
        }
        this.deviceInfo.setLocationListening(false);
        return instance;
    }

    public Tracker setDebug(boolean debug) {
        Logy.setDebug(debug);
        this.debug = debug;
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker pageViewStart(String pageName, Props props) {
        PageInfo page = new PageInfo(pageName, props);
        Stack<PageInfo> stack = this.pvStack;
        synchronized (stack) {
            this.pvStack.push(page);
        }
        this.logPvAsync(page, true);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker pageViewEnd(String pageName) {
        try {
            Stack<PageInfo> stack = this.pvStack;
            synchronized (stack) {
                PageInfo page = this.pvStack.peek();
                if (!pageName.equals(page.pageName)) {
                    Logy.e(TAG, "pageViewEnd:" + pageName + "\u6ca1\u88ab\u8c03\u7528\uff0c\u9875\u9762:" + page.pageName);
                } else {
                    this.pvStack.pop();
                    this.logPvAsync(page, false);
                }
            }
        }
        catch (EmptyStackException e) {
            Logy.e(TAG, "pageViewEnd: without pageViewStart:" + pageName);
        }
        return this;
    }

    protected void logPvAsync(final PageInfo page, final boolean start) {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Tracker.this.logPvIntenal(page, start ? -1L : page.getTimeSpend(), start ? "pvStart" : "pvEnd");
                }
                catch (Exception e) {
                    Logy.e(Tracker.TAG, "error in logPvAsync", e);
                }
            }
        });
    }

    private long logPvIntenal(PageInfo page, long time, String stage) {
        Logy.d(TAG, "Logged pv: " + page.pageName + ", " + stage + ", " + time);
        JSONObject event = this.fillHeaderData("event");
        this.fillUserInfo(event, page, Props.empty());
        this.fillPageInfo(event, page, Props.empty());
        try {
            JSONObject eventProperties = null;
            eventProperties = page.props != null ? new JSONObject(page.props.evars) : new JSONObject();
            if (time != -1L) {
                eventProperties.put("pvtime", time);
            }
            event.put("e_cat", this.replaceWithJSONNull("/pv"));
            event.put("e_act", this.replaceWithJSONNull(stage));
            event.put("e_var", (Object)this.truncate(eventProperties));
        }
        catch (JSONException e) {
            Logy.e(TAG, "error in logPvIntenal", e);
        }
        return this.saveEvent("event", event);
    }

    public void logEvent(String eventCatlog, String eventAction) {
        this.logEvent(eventCatlog, eventAction, null);
    }

    public void logEvent(String eventCatlog, String eventAction, Props props) {
        if (this.validateLogEvent(eventCatlog)) {
            this.logEventAsync(eventCatlog, eventAction, props, this.getCurrentTimeMillis());
        }
    }

    public void logEventSync(String eventCatlog, String eventAction, Props props) {
        long eventId = this.logEventIntenal(eventCatlog, eventAction, props, this.getCurrentTimeMillis());
        DatabaseHelper dbHelper = DatabaseHelper.getDatabaseHelper(this.context);
        try {
            JSONObject event = dbHelper.getEvent(eventId);
            if (event != null) {
                this.uploading.add(eventId);
                final ArrayList<JSONObject> events = new ArrayList<JSONObject>();
                events.add(event);
                this.httpThread.post(new Runnable(){

                    @Override
                    public void run() {
                        Tracker.this.sendLogReq(events);
                    }
                });
                Thread.sleep(200L);
            }
        }
        catch (JSONException jSONException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected boolean validateLogEvent(String eventType) {
        if (TextUtils.isEmpty((CharSequence)eventType)) {
            Logy.e(TAG, "Argument eventType cannot be null or blank in logEvent()");
            return false;
        }
        return this.contextSet("logEvent()");
    }

    protected void logEventAsync(final String eventCatlog, final String eventAction, Props props, final long timestamp) {
        final Props copyProps = props == null ? null : props.copy();
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                Tracker.this.logEventIntenal(eventCatlog, eventAction, copyProps, timestamp);
            }
        });
    }

    protected long logEventIntenal(String eventCatlog, String eventAction, Props props, long timestamp) {
        boolean loggingSessionEvent;
        Logy.d(TAG, "Logged event: " + eventCatlog);
        boolean bl = loggingSessionEvent = this.trackingSessionEvents && (eventCatlog.equals(START_SESSION_EVENT) || eventCatlog.equals(END_SESSION_EVENT));
        if (!loggingSessionEvent) {
            if (!this.inForeground) {
                this.startNewSessionIfNeeded(timestamp);
            } else {
                this.refreshSessionTime(timestamp);
            }
        }
        try {
            JSONObject event = this.fillHeaderData("event");
            try {
                PageInfo page = this.pvStack.peek();
                this.fillUserInfo(event, page, props);
                this.fillPageInfo(event, page, props);
            }
            catch (EmptyStackException page) {
                // empty catch block
            }
            JSONObject eventProperties = null;
            eventProperties = props != null && props.evars.size() > 0 ? new JSONObject(props.evars) : new JSONObject();
            try {
                if (TextUtils.isEmpty((CharSequence)eventCatlog)) {
                    eventCatlog = "/";
                } else if (!eventCatlog.startsWith("/")) {
                    eventCatlog = "/" + eventCatlog;
                }
                event.put("e_cat", this.replaceWithJSONNull(eventCatlog));
                event.put("e_act", this.replaceWithJSONNull(eventAction));
                event.put("e_var", (Object)this.truncate(eventProperties));
            }
            catch (JSONException e) {
                Logy.e(TAG, "error in logEventIntenal", e);
            }
            return this.saveEvent("event", event);
        }
        catch (Exception e) {
            Logy.e(TAG, "error in logEventIntenal", e);
            return 0L;
        }
    }

    protected long saveEvent(String eventType, JSONObject event) {
        long totalEventCount;
        long eventId;
        DatabaseHelper dbHelper = DatabaseHelper.getDatabaseHelper(this.context);
        if (eventType.equals("$identify")) {
            eventId = dbHelper.addIdentify(event.toString());
            this.setLastIdentifyId(eventId);
        } else {
            eventId = dbHelper.addEvent(event.toString());
            this.setLastEventId(eventId);
        }
        int numEventsToRemove = Math.min(Math.max(1, this.eventMaxCount / 10), 20);
        if (dbHelper.getEventCount() > (long)this.eventMaxCount) {
            Logy.i("Firedata.sdk.Tracker", "remove some event");
            dbHelper.removeEvents(dbHelper.getNthEventId(numEventsToRemove));
        }
        if (dbHelper.getIdentifyCount() > (long)this.eventMaxCount) {
            dbHelper.removeIdentifys(dbHelper.getNthIdentifyId(numEventsToRemove));
        }
        if ((totalEventCount = dbHelper.getTotalEventCount()) % (long)this.eventUploadThreshold == 0L && totalEventCount >= (long)this.eventUploadThreshold) {
            this.updateServer();
        } else {
            this.updateServerLater(this.eventUploadPeriodMillis);
        }
        return eventId;
    }

    private JSONObject fillHeaderData(String catlog) {
        JSONObject hit = new JSONObject();
        try {
            hit.put("ts", this.getCurrentTimeMillis());
            hit.put("guid", this.replaceWithJSONNull(this.guid));
            hit.put("guidts", this.replaceWithJSONNull(this.guidts));
            hit.put("guidvc", this.replaceWithJSONNull(this.guidvc));
            hit.put("guidlvts", this.replaceWithJSONNull(this.guidlvts));
            hit.put("app_id", this.replaceWithJSONNull(this.appKey));
            hit.put("channel", this.replaceWithJSONNull(this.channel));
            hit.put("app_name", this.replaceWithJSONNull(this.deviceInfo.getAppName()));
            hit.put("app_version", this.replaceWithJSONNull(this.deviceInfo.getVersionName()));
            hit.put("app_version_code", this.replaceWithJSONNull(this.deviceInfo.getVersionCode()));
            hit.put("app_instime", this.replaceWithJSONNull(this.deviceInfo.getFirstInstallTime()));
            hit.put("app_uptime", this.replaceWithJSONNull(this.deviceInfo.getLastUpdateTime()));
            hit.put("installer", this.replaceWithJSONNull(this.deviceInfo.getInstaller()));
            hit.put("d_brand", this.replaceWithJSONNull(this.deviceInfo.getBrand()));
            hit.put("d_model", this.replaceWithJSONNull(this.deviceInfo.getModel()));
            hit.put("d_manu", this.replaceWithJSONNull(this.deviceInfo.getManufacturer()));
            hit.put("os_name", this.replaceWithJSONNull(this.deviceInfo.getOsName()));
            hit.put("os_version", this.replaceWithJSONNull(this.deviceInfo.getOsVersion()));
            hit.put("platform", (Object)"Android");
            hit.put("country", this.replaceWithJSONNull(this.deviceInfo.getCountry()));
            hit.put("lan", this.replaceWithJSONNull(this.deviceInfo.getLanguage()));
            hit.put("timezone", this.replaceWithJSONNull(this.deviceInfo.getTimezone()));
            hit.put("operator", this.replaceWithJSONNull(this.deviceInfo.getCarrier()));
            hit.put("width", this.replaceWithJSONNull(this.deviceInfo.getDisplayWidth()));
            hit.put("height", this.replaceWithJSONNull(this.deviceInfo.getDisplayHeight()));
            hit.put("mac", this.replaceWithJSONNull(this.deviceInfo.getMac()));
            hit.put("imei", this.replaceWithJSONNull(this.deviceInfo.getImei()));
            hit.put("wifi", this.replaceWithJSONNull(this.deviceInfo.getWifiName()));
            hit.put("network_type", this.replaceWithJSONNull(this.deviceInfo.getNetworkType()));
            hit.put("bluetooth", this.deviceInfo.getBluetoothState());
            hit.put("elctricity", this.deviceInfo.getElctricity());
            hit.put("headset", this.deviceInfo.getHeadset());
            hit.put("landscape", this.deviceInfo.getLandscape());
            hit.put("ab", this.replaceWithJSONNull(this.abVersion));
            hit.put("no", this.getNextSequenceNumber());
            hit.put("session_id", this.sessionId);
            hit.put("catlog", (Object)catlog);
            float[] xyz = this.deviceInfo.getXYZ();
            hit.put("x", (double)xyz[0]);
            hit.put("y", (double)xyz[1]);
            hit.put("z", (double)xyz[2]);
            Location location = this.deviceInfo.getMostRecentLocation();
            if (location != null) {
                hit.put("lat", location.getLatitude());
                hit.put("lng", location.getLongitude());
            }
        }
        catch (JSONException e) {
            Logy.e(TAG, "error in fillHeaderData", e);
        }
        return hit;
    }

    private void fillUserInfo(JSONObject hit, PageInfo page, Props props) {
        try {
            HashMap<String, Object> uvars = new HashMap<String, Object>(this.userVars);
            if (page != null && page.props != null) {
                uvars.putAll(page.props.uvars);
            }
            if (props != null) {
                uvars.putAll(props.uvars);
            }
            hit.put("uid", this.replaceWithJSONNull(this.userId));
            hit.put("uvars", (Object)Utils.toJsonString(uvars));
        }
        catch (JSONException e) {
            Logy.e(TAG, "error in fillUserInfo", e);
        }
    }

    private void fillPageInfo(JSONObject hit, PageInfo page, Props props) {
        try {
            if (page != null) {
                Props pageProps = page.props;
                if (pageProps == null) {
                    pageProps = Props.empty();
                }
                if (props == null) {
                    props = Props.empty();
                }
                hit.put("page", (Object)page.pageName);
                hit.put("transactionid", (Object)page.trasactionId);
                hit.put("c_id", this.replaceWithJSONNull(pageProps.contentId == null ? props.contentId : pageProps.contentId));
                hit.put("c_ch", this.replaceWithJSONNull(pageProps.contentCat == null ? props.contentCat : pageProps.contentCat));
                hit.put("c_vars", this.replaceWithJSONNull(Utils.toJsonString(pageProps.cvars.isEmpty() ? props.cvars : pageProps.cvars)));
            } else if (props != null) {
                hit.put("c_ch", this.replaceWithJSONNull(props.contentCat));
                hit.put("c_id", this.replaceWithJSONNull(props.contentId));
                hit.put("c_vars", this.replaceWithJSONNull(Utils.toJsonString(props.cvars)));
            }
        }
        catch (JSONException e) {
            Logy.e(TAG, "error in fillPageInfo", e);
        }
    }

    long getNextSequenceNumber() {
        DatabaseHelper dbHelper = DatabaseHelper.getDatabaseHelper(this.context);
        Long sequenceNumber = dbHelper.getLongValue(SEQUENCE_NUMBER_KEY);
        if (sequenceNumber == null) {
            sequenceNumber = 0L;
        }
        Long l = sequenceNumber;
        Long l2 = sequenceNumber = Long.valueOf(sequenceNumber + 1L);
        dbHelper.insertOrReplaceKeyLongValue(SEQUENCE_NUMBER_KEY, sequenceNumber);
        return sequenceNumber;
    }

    long getLastEventTime() {
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        return preferences.getLong("com.firedata.sdk.lastEventTime", -1L);
    }

    void setLastEventTime(long timestamp) {
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        preferences.edit().putLong("com.firedata.sdk.lastEventTime", timestamp).commit();
    }

    long getLastEventId() {
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        return preferences.getLong("com.firedata.sdk.lastEventId", -1L);
    }

    void setLastEventId(long eventId) {
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        preferences.edit().putLong("com.firedata.sdk.lastEventId", eventId).commit();
    }

    long getLastIdentifyId() {
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        return preferences.getLong("com.firedata.sdk.lastIdentifyId", -1L);
    }

    void setLastIdentifyId(long identifyId) {
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        preferences.edit().putLong("com.firedata.sdk.lastIdentifyId", identifyId).commit();
    }

    long getPreviousSessionId() {
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        return preferences.getLong("com.firedata.sdk.previousSessionId", -1L);
    }

    void setPreviousSessionId(long timestamp) {
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        preferences.edit().putLong("com.firedata.sdk.previousSessionId", timestamp).commit();
    }

    boolean startNewSessionIfNeeded(long timestamp) {
        if (this.inSession()) {
            if (this.isWithinMinTimeBetweenSessions(timestamp)) {
                this.refreshSessionTime(timestamp);
                return false;
            }
            this.startNewSession(timestamp);
            return true;
        }
        if (this.isWithinMinTimeBetweenSessions(timestamp)) {
            long previousSessionId = this.getPreviousSessionId();
            if (previousSessionId == -1L) {
                this.startNewSession(timestamp);
                return true;
            }
            this.setSessionId(previousSessionId);
            this.refreshSessionTime(timestamp);
            return false;
        }
        this.startNewSession(timestamp);
        return true;
    }

    private void startNewSession(long timestamp) {
        this.setSessionId(timestamp);
        this.refreshSessionTime(timestamp);
    }

    private boolean inSession() {
        return this.sessionId >= 0L;
    }

    private boolean isWithinMinTimeBetweenSessions(long timestamp) {
        long sessionLimit;
        long lastEventTime = this.getLastEventTime();
        return timestamp - lastEventTime < (sessionLimit = this.sessionTimeoutMillis);
    }

    private void setSessionId(long timestamp) {
        this.sessionId = timestamp;
        this.setPreviousSessionId(timestamp);
    }

    void refreshSessionTime(long timestamp) {
        if (!this.inSession()) {
            return;
        }
        this.setLastEventTime(timestamp);
    }

    void onExitForeground(final long timestamp) {
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                Tracker.this.refreshSessionTime(timestamp);
                Tracker.this.inForeground = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onEnterForeground(final long timestamp) {
        if (this.lastExitForegroundTime > 0L) {
            long delta = this.lastExitForegroundTime - System.currentTimeMillis();
            Stack<PageInfo> stack = this.pvStack;
            synchronized (stack) {
                for (PageInfo page : this.pvStack) {
                    page.addDelta(delta);
                }
            }
        }
        this.runOnLogThread(new Runnable(){

            @Override
            public void run() {
                Tracker.this.startNewSessionIfNeeded(timestamp);
                Tracker.this.inForeground = true;
            }
        });
    }

    public void background() {
        this.lastExitForegroundTime = System.currentTimeMillis();
        Logy.d(TAG, "background: " + this.lastExitForegroundTime);
    }

    public void foreground() {
        if (this.lastExitForegroundTime > 0L) {
            final long delta = this.lastExitForegroundTime - System.currentTimeMillis();
            this.lastExitForegroundTime = 0L;
            Logy.d(TAG, "foreground delta: " + delta);
            this.runOnLogThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Stack stack = Tracker.this.pvStack;
                    synchronized (stack) {
                        for (PageInfo page : Tracker.this.pvStack) {
                            page.addDelta(delta);
                        }
                    }
                }
            });
        }
    }

    protected JSONObject truncate(JSONObject object) {
        if (object == null) {
            return null;
        }
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = object.get(key);
                if (value.getClass().equals(String.class)) {
                    object.put(key, (Object)this.truncate((String)value));
                    continue;
                }
                if (value.getClass().equals(JSONObject.class)) {
                    object.put(key, (Object)this.truncate((JSONObject)value));
                    continue;
                }
                if (!value.getClass().equals(JSONArray.class)) continue;
                object.put(key, (Object)this.truncate((JSONArray)value));
            }
            catch (JSONException e) {
                Logy.e(TAG, e.toString());
            }
        }
        return object;
    }

    protected JSONArray truncate(JSONArray array) throws JSONException {
        if (array == null) {
            return null;
        }
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            if (value.getClass().equals(String.class)) {
                array.put(i, (Object)this.truncate((String)value));
                continue;
            }
            if (value.getClass().equals(JSONObject.class)) {
                array.put(i, (Object)this.truncate((JSONObject)value));
                continue;
            }
            if (!value.getClass().equals(JSONArray.class)) continue;
            array.put(i, (Object)this.truncate((JSONArray)value));
        }
        return array;
    }

    protected String truncate(String value) {
        return value.length() <= 1024 ? value : value.substring(0, 1024);
    }

    public String getUserId() {
        return this.userId;
    }

    public Tracker setUserId(String userId) {
        if (!this.contextSet("setUserId()")) {
            return this;
        }
        this.userId = userId;
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        preferences.edit().putString("com.firedata.sdk.userId", userId).commit();
        return this;
    }

    public Tracker setUserVars(Map<String, Object> userInfo) {
        this.userVars = userInfo == null ? new ConcurrentHashMap() : new ConcurrentHashMap<String, Object>(userInfo);
        SharedPreferences preferences = this.context.getSharedPreferences(this.getSharedPreferencesName(), 0);
        if (userInfo != null && !userInfo.isEmpty()) {
            preferences.edit().putString("fd_uvar", Utils.toJsonString(userInfo)).commit();
        } else {
            preferences.edit().remove("fd_uvar").commit();
        }
        return this;
    }

    public Map<String, Object> getUserVars() {
        return this.userVars;
    }

    public Tracker setGuid(String guid) {
        Set<String> invalidDeviceIds = this.getInvalidDeviceIds();
        if (!this.contextSet("setGuid()") || TextUtils.isEmpty((CharSequence)guid) || invalidDeviceIds.contains(guid)) {
            return this;
        }
        this.guid = guid;
        DatabaseHelper.getDatabaseHelper(this.context).insertOrReplaceKeyValue(GUID_KEY, guid);
        return this;
    }

    protected void uploadEvents() {
        if (!this.contextSet("uploadEvents()")) {
            return;
        }
        this.logThread.post(new Runnable(){

            @Override
            public void run() {
                Tracker.this.updateServer();
            }
        });
    }

    private void updateServerLater(long delayMillis) {
        if (this.updateScheduled.getAndSet(true)) {
            return;
        }
        this.logThread.postDelayed(new Runnable(){

            @Override
            public void run() {
                Tracker.this.updateScheduled.set(false);
                Tracker.this.updateServer();
            }
        }, delayMillis);
    }

    protected void updateServer() {
        this.updateServer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateServer(boolean some) {
        if (!this.uploadingCurrently.getAndSet(true)) {
            try {
                if (!this.checkConfig()) {
                    this.startLoadSrvConfig();
                    throw new IllegalStateException("config not ready, try later");
                }
                DatabaseHelper dbHelper = DatabaseHelper.getDatabaseHelper(this.context);
                List<JSONObject> events = dbHelper.getEvents(this.getLastEventId(), this.uploading.size() + this.eventUploadMaxBatchSize);
                if (this.debug && events.size() > 0) {
                    Logy.d(TAG, "send logs count:" + events.size());
                }
                ArrayList<JSONObject> toSendings = new ArrayList<JSONObject>();
                for (JSONObject event : events) {
                    long eventid = event.getLong("event_id");
                    if (this.uploading.contains(eventid)) continue;
                    toSendings.add(event);
                    this.uploading.add(event.getLong("event_id"));
                }
                for (int i = 0; i < toSendings.size(); i += this.eventUploadMaxBatchSize) {
                    final List items = toSendings.subList(i, i + this.eventUploadMaxBatchSize < toSendings.size() ? i + this.eventUploadMaxBatchSize : toSendings.size());
                    this.httpThread.post(new Runnable(){

                        @Override
                        public void run() {
                            Tracker.this.sendLogReq(items);
                        }
                    });
                }
            }
            catch (Exception e) {
                Logy.e(TAG, "error in updateServer", e);
            }
            finally {
                this.uploadingCurrently.set(false);
                if (this.sendErrCount > 10) {
                    this.updateServerLater(this.eventUploadPeriodMillis * 6L);
                } else if (this.sendErrCount > 20) {
                    this.updateServerLater(this.eventUploadPeriodMillis * 24L);
                } else {
                    this.updateServerLater(this.eventUploadPeriodMillis);
                }
            }
        }
    }

    private void buildReqData(JSONObject event, BufferedSink bo) {
        Iterator keys = event.keys();
        try {
            while (keys.hasNext()) {
                String k = (String)keys.next();
                Object v = event.get(k);
                if (v == JSONObject.NULL || v == null) continue;
                bo.write(URLEncoder.encode(k, "UTF-8").getBytes());
                bo.writeByte(61);
                bo.write(URLEncoder.encode(v.toString(), "UTF-8").getBytes());
                bo.writeByte(38);
            }
            bo.write("sdk_version".getBytes());
            bo.writeByte(61);
            bo.write("3.6".getBytes());
        }
        catch (IOException | JSONException throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    private void sendLogReq(List<JSONObject> items) {
        String eventIds = "";
        for (Object event : items) {
            try {
                eventIds = eventIds + event.getLong("event_id") + ", ";
            }
            catch (JSONException jSONException) {}
        }
        if (this.abandonLog()) {
            if (this.debug) {
                Logy.d(TAG, "abandon events" + eventIds);
            }
            DatabaseHelper dbHelper = DatabaseHelper.getDatabaseHelper(this.context);
            for (JSONObject event : items) {
                try {
                    dbHelper.removeEvent(event.getLong("event_id"));
                    this.uploading.remove(event.getLong("event_id"));
                }
                catch (JSONException jSONException) {}
            }
        }
        try {
            Request request;
            Response response;
            String url = this.getUrl();
            if (this.debug) {
                Logy.d(TAG, "send events" + eventIds + "to " + (String)url);
                Logy.d(TAG, "Evt " + items);
            }
            if ((response = new OkHttpClient().newCall(request = new Request.Builder().url(url).header("Content-Encoding", "gzip").post(this.gzipReaquestBody(items)).build()).execute()).code() == 200) {
                DatabaseHelper dbHelper = DatabaseHelper.getDatabaseHelper(this.context);
                for (JSONObject event : items) {
                    dbHelper.removeEvent(event.getLong("event_id"));
                }
                this.sendErrCount = 0;
            } else {
                if (this.debug) {
                    Logy.d(TAG, "send events Error:" + response.code());
                }
                ++this.sendErrCount;
            }
        }
        catch (IOException | JSONException e) {
            ++this.sendErrCount;
            Logy.e(TAG, "error in sendLogReq", e);
        }
        catch (Exception e) {
            Logy.e(TAG, "error in sendLogReq", e);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            for (Object event : items) {
                try {
                    this.uploading.remove(event.getLong("event_id"));
                }
                catch (JSONException jSONException) {}
            }
        }
        for (Object event : items) {
            try {
                this.uploading.remove(event.getLong("event_id"));
            }
            catch (JSONException jSONException) {}
        }
    }

    private RequestBody gzipReaquestBody(final List<JSONObject> items) {
        return new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)"text/plain; charset=utf-8");
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                BufferedSink gzipSink = Okio.buffer((Sink)new GzipSink((Sink)sink));
                for (JSONObject event : items) {
                    Tracker.this.buildReqData(event, gzipSink);
                    gzipSink.writeByte(10);
                }
                gzipSink.close();
            }
        };
    }

    private String getUrl() {
        return (this.getConfigParamBoolean("https", false) ? "https://" : "http://") + this.getConfigParam("log_host", "127.0.0.1") + "/log/v" + 3 + "/" + this.getConfigParam("app_key", this.appKey) + "/android_event";
    }

    private boolean abandonLog() {
        return "blackHole".equalsIgnoreCase(this.getConfigParam("log_host", "").toString());
    }

    private boolean checkConfig() {
        return null != this.getConfigParam("log_host", null);
    }

    public String getGuid() {
        if (!TextUtils.isEmpty((CharSequence)this.customGUID)) {
            return this.customGUID;
        }
        return this.guid;
    }

    public String getGuidSync() {
        if (!TextUtils.isEmpty((CharSequence)this.customGUID)) {
            return this.customGUID;
        }
        if (!TextUtils.isEmpty((CharSequence)this.guid)) {
            return this.guid;
        }
        this.deviceInfo.prefetch();
        this.initializeGUID();
        return this.guid;
    }

    public String getMac() {
        return this.deviceInfo.getMac();
    }

    public Object getConfigParam(String key) {
        return this.configFromServer.get(key);
    }

    public Object getConfigParam(String key, Object defaultVal) {
        Object ret = this.configFromServer.get(key);
        return ret == null ? defaultVal : ret;
    }

    public boolean getConfigParamBoolean(String key, boolean defaultVal) {
        Object ret = this.configFromServer.get(key);
        if (ret != null && ret instanceof Boolean) {
            return (Boolean)ret;
        }
        return defaultVal;
    }

    private Set<String> getInvalidDeviceIds() {
        HashSet<String> invalidDeviceIds = new HashSet<String>();
        invalidDeviceIds.add("");
        invalidDeviceIds.add("9774d56d682e549c");
        invalidDeviceIds.add("unknown");
        invalidDeviceIds.add("000000000000000");
        invalidDeviceIds.add("Android");
        invalidDeviceIds.add("DEFACE");
        return invalidDeviceIds;
    }

    @TargetApi(value=9)
    private void initializeGUID() {
        Set<String> invalidIds = this.getInvalidDeviceIds();
        DatabaseHelper dbHelper = DatabaseHelper.getDatabaseHelper(this.context);
        String guidInfoStr = dbHelper.getValue(GUID_INFO);
        if (!TextUtils.isEmpty((CharSequence)this.customGUID)) {
            this.guid = this.customGUID;
            try {
                if (!TextUtils.isEmpty((CharSequence)guidInfoStr)) {
                    JSONObject guidInfo = new JSONObject(guidInfoStr);
                    String tmpGuid = guidInfo.getString("guid");
                    if (this.customGUID.equals(tmpGuid)) {
                        this.guidts = guidInfo.getLong("guidts");
                        this.guidvc = guidInfo.getLong("guidvc");
                        this.guidlvts = guidInfo.getLong("guidlvts");
                        guidInfo.put("guidvc", this.guidvc + 1L);
                        guidInfo.put("guidlvts", System.currentTimeMillis());
                    } else {
                        guidInfo.put("guid", (Object)this.guid);
                        guidInfo.put("guidts", this.guidts);
                        guidInfo.put("guidvc", this.guidvc);
                        guidInfo.put("guidlvts", this.guidlvts);
                    }
                    dbHelper.insertOrReplaceKeyValue(GUID_INFO, guidInfo.toString());
                    return;
                }
                JSONObject guidInfo = new JSONObject();
                guidInfo.put("guid", (Object)this.guid);
                guidInfo.put("guidts", this.guidts);
                guidInfo.put("guidvc", this.guidvc);
                guidInfo.put("guidlvts", this.guidlvts);
                dbHelper.insertOrReplaceKeyValue(GUID_INFO, guidInfo.toString());
                return;
            }
            catch (JSONException guidInfo) {
                // empty catch block
            }
        }
        if (!TextUtils.isEmpty((CharSequence)guidInfoStr)) {
            try {
                JSONObject guidInfo = new JSONObject(guidInfoStr);
                this.guid = guidInfo.getString("guid");
                this.guidts = guidInfo.getLong("guidts");
                this.guidvc = guidInfo.getLong("guidvc");
                this.guidlvts = guidInfo.getLong("guidlvts");
                guidInfo.put("guidvc", this.guidvc + 1L);
                guidInfo.put("guidlvts", System.currentTimeMillis());
                dbHelper.insertOrReplaceKeyValue(GUID_INFO, guidInfo.toString());
                return;
            }
            catch (JSONException guidInfo) {
                // empty catch block
            }
        }
        JSONObject guidInfo = new JSONObject();
        try {
            guidInfo.put("guidts", this.guidts);
            guidInfo.put("guidvc", this.guidvc);
            guidInfo.put("guidlvts", this.guidlvts);
        }
        catch (JSONException tmpGuid) {
            // empty catch block
        }
        String deviceId = dbHelper.getValue(GUID_KEY);
        if (!TextUtils.isEmpty((CharSequence)deviceId) && !invalidIds.contains(deviceId)) {
            this.guid = deviceId;
            try {
                guidInfo.put("guid", (Object)this.guid);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            dbHelper.insertOrReplaceKeyValue(GUID_INFO, guidInfo.toString());
            return;
        }
        MD5 messageDigest = new MD5();
        String mac = this.deviceInfo.getMac();
        String imei = this.deviceInfo.getImei();
        if (!(this.newDeviceIdPerInstall || TextUtils.isEmpty((CharSequence)mac) || TextUtils.isEmpty((CharSequence)imei) || invalidIds.contains(mac) || invalidIds.contains(imei))) {
            this.guid = this.bytesToHexString(messageDigest.digest((mac + "&" + imei).getBytes(UTF8)));
            try {
                guidInfo.put("guid", (Object)this.guid);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            dbHelper.insertOrReplaceKeyValue(GUID_INFO, guidInfo.toString());
            return;
        }
        this.guid = this.bytesToHexString(messageDigest.digest(((TextUtils.isEmpty((CharSequence)mac) ? "" : mac) + this.deviceInfo.generateUUID() + "R").getBytes(UTF8)));
        try {
            guidInfo.put("guid", (Object)this.guid);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        dbHelper.insertOrReplaceKeyValue(GUID_INFO, guidInfo.toString());
    }

    private void runOnLogThread(Runnable r) {
        if (Thread.currentThread() != this.logThread) {
            this.logThread.post(r);
        } else {
            r.run();
        }
    }

    protected Object replaceWithJSONNull(Object obj) {
        return obj == null ? JSONObject.NULL : obj;
    }

    protected synchronized boolean contextSet(String methodName) {
        if (this.context == null) {
            Logy.e(TAG, "context cannot be null, set context with initialize() before calling " + methodName);
            return false;
        }
        return true;
    }

    protected String getSharedPreferencesName() {
        return "com.firedata.sdk." + this.context.getPackageName();
    }

    protected String bytesToHexString(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    protected JSONObject cloneJSONObject(JSONObject obj) {
        if (obj == null) {
            return null;
        }
        JSONArray nameArray = null;
        try {
            nameArray = obj.names();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Logy.e(TAG, e.toString());
        }
        int len = nameArray != null ? nameArray.length() : 0;
        String[] names = new String[len];
        for (int i = 0; i < len; ++i) {
            names[i] = nameArray.optString(i);
        }
        try {
            return new JSONObject(obj, names);
        }
        catch (JSONException e) {
            Logy.e(TAG, e.toString());
            return null;
        }
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }
}

