/*
 * Decompiled with CFR 0.152.
 */
package com.firedata.sdk;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import com.firedata.sdk.tools.Logy;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class DatabaseHelper
extends SQLiteOpenHelper {
    static DatabaseHelper instance;
    private static final String TAG = "com.firedata.DatabaseHelper";
    protected static final String STORE_TABLE_NAME = "store";
    protected static final String LONG_STORE_TABLE_NAME = "long_store";
    private static final String KEY_FIELD = "key";
    private static final String VALUE_FIELD = "value";
    protected static final String EVENT_TABLE_NAME = "events";
    protected static final String IDENTIFY_TABLE_NAME = "identifys";
    private static final String ID_FIELD = "id";
    private static final String EVENT_FIELD = "event";
    private static final String CREATE_STORE_TABLE = "CREATE TABLE IF NOT EXISTS store (key TEXT PRIMARY KEY NOT NULL, value TEXT);";
    private static final String CREATE_LONG_STORE_TABLE = "CREATE TABLE IF NOT EXISTS long_store (key TEXT PRIMARY KEY NOT NULL, value INTEGER);";
    private static final String CREATE_EVENTS_TABLE = "CREATE TABLE IF NOT EXISTS events (id INTEGER PRIMARY KEY AUTOINCREMENT, event TEXT);";
    private static final String CREATE_IDENTIFYS_TABLE = "CREATE TABLE IF NOT EXISTS identifys (id INTEGER PRIMARY KEY AUTOINCREMENT, event TEXT);";
    private File file;

    static synchronized DatabaseHelper getDatabaseHelper(Context context) {
        if (instance == null) {
            instance = new DatabaseHelper(context.getApplicationContext());
        }
        return instance;
    }

    private DatabaseHelper(Context context) {
        super(context, "com.firedata.sdk", null, 3);
        this.file = context.getDatabasePath("com.firedata.sdk");
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_STORE_TABLE);
        db.execSQL(CREATE_LONG_STORE_TABLE);
        db.execSQL(CREATE_EVENTS_TABLE);
        db.execSQL(CREATE_IDENTIFYS_TABLE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion > newVersion) {
            Logy.e(TAG, "onUpgrade() with invalid oldVersion and newVersion");
            this.resetDatabase(db);
            return;
        }
        if (newVersion <= 1) {
            return;
        }
        switch (oldVersion) {
            case 1: {
                db.execSQL(CREATE_STORE_TABLE);
                if (newVersion <= 2) break;
            }
            case 2: {
                db.execSQL(CREATE_IDENTIFYS_TABLE);
                db.execSQL(CREATE_LONG_STORE_TABLE);
                if (newVersion <= 3) break;
            }
            case 3: {
                break;
            }
            default: {
                Logy.e(TAG, "onUpgrade() with unknown oldVersion " + oldVersion);
                this.resetDatabase(db);
            }
        }
    }

    private void resetDatabase(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS store");
        db.execSQL("DROP TABLE IF EXISTS long_store");
        db.execSQL("DROP TABLE IF EXISTS events");
        db.execSQL("DROP TABLE IF EXISTS identifys");
        this.onCreate(db);
    }

    synchronized long insertOrReplaceKeyValue(String key, String value) {
        return this.insertOrReplaceKeyValueToTable(STORE_TABLE_NAME, key, value);
    }

    synchronized long insertOrReplaceKeyLongValue(String key, Long value) {
        return this.insertOrReplaceKeyValueToTable(LONG_STORE_TABLE_NAME, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long insertOrReplaceKeyValueToTable(String table, String key, Object value) {
        long result = -1L;
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put(KEY_FIELD, key);
            if (value instanceof Long) {
                contentValues.put(VALUE_FIELD, (Long)value);
            } else {
                contentValues.put(VALUE_FIELD, (String)value);
            }
            result = db.insertWithOnConflict(table, null, contentValues, 5);
            if (result == -1L) {
                Logy.w(TAG, "Insert failed");
            }
        }
        catch (SQLiteException e) {
            Logy.e(TAG, "insertOrReplaceKeyValue failed", e);
            this.delete();
        }
        finally {
            this.close();
        }
        return result;
    }

    synchronized long addEvent(String event) {
        return this.addEventToTable(EVENT_TABLE_NAME, event);
    }

    synchronized long addIdentify(String identifyEvent) {
        return this.addEventToTable(IDENTIFY_TABLE_NAME, identifyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long addEventToTable(String table, String event) {
        long result = -1L;
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            ContentValues contentValues = new ContentValues();
            contentValues.put(EVENT_FIELD, event);
            result = db.insert(table, null, contentValues);
            if (result == -1L) {
                Logy.w(TAG, String.format("Insert into %s failed", table));
            }
        }
        catch (SQLiteException e) {
            Logy.e(TAG, String.format("addEvent to %s failed", table), e);
            this.delete();
        }
        finally {
            this.close();
        }
        return result;
    }

    synchronized String getValue(String key) {
        return (String)this.getValueFromTable(STORE_TABLE_NAME, key);
    }

    synchronized Long getLongValue(String key) {
        return (Long)this.getValueFromTable(LONG_STORE_TABLE_NAME, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Object getValueFromTable(String table, String key) {
        Object value = null;
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            cursor = db.query(table, new String[]{KEY_FIELD, VALUE_FIELD}, "key = ?", new String[]{key}, null, null, null, null);
            if (cursor.moveToFirst()) {
                value = table.equals(STORE_TABLE_NAME) ? cursor.getString(1) : Long.valueOf(cursor.getLong(1));
            }
        }
        catch (SQLiteException e) {
            Logy.e(TAG, "getValue failed", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.close();
        }
        return value;
    }

    synchronized List<JSONObject> getEvents(long upToId, int limit) throws JSONException {
        return this.getEventsFromTable(EVENT_TABLE_NAME, upToId, limit);
    }

    synchronized JSONObject getEvent(long eventId) throws JSONException {
        return this.getEventFromTable(EVENT_TABLE_NAME, eventId);
    }

    synchronized List<JSONObject> getIdentifys(long upToId, int limit) throws JSONException {
        return this.getEventsFromTable(IDENTIFY_TABLE_NAME, upToId, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<JSONObject> getEventsFromTable(String table, long upToId, int limit) throws JSONException {
        LinkedList<JSONObject> events = new LinkedList<JSONObject>();
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            cursor = db.query(table, new String[]{ID_FIELD, EVENT_FIELD}, upToId >= 0L ? "id <= " + upToId : null, null, null, null, "id ASC", limit >= 0 ? "" + limit : null);
            while (cursor.moveToNext()) {
                long eventId = cursor.getLong(0);
                String event = cursor.getString(1);
                JSONObject obj = new JSONObject(event);
                obj.put("event_id", eventId);
                events.add(obj);
            }
        }
        catch (SQLiteException e) {
            Logy.e(TAG, String.format("getEvents from %s failed", table), e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.close();
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized JSONObject getEventFromTable(String table, long eventId) throws JSONException {
        Cursor cursor = null;
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            cursor = db.query(table, new String[]{ID_FIELD, EVENT_FIELD}, "id = " + eventId, null, null, null, null, null);
            if (cursor.moveToNext()) {
                String event = cursor.getString(1);
                JSONObject obj = new JSONObject(event);
                obj.put("event_id", cursor.getLong(0));
                JSONObject jSONObject = obj;
                return jSONObject;
            }
        }
        catch (SQLiteException e) {
            Logy.e(TAG, String.format("getEvents from %s failed", table), e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.close();
        }
        return null;
    }

    synchronized long getEventCount() {
        return this.getEventCountFromTable(EVENT_TABLE_NAME);
    }

    synchronized long getIdentifyCount() {
        return this.getEventCountFromTable(IDENTIFY_TABLE_NAME);
    }

    synchronized long getTotalEventCount() {
        return this.getEventCount() + this.getIdentifyCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long getEventCountFromTable(String table) {
        long numberRows = 0L;
        SQLiteStatement statement = null;
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            String query = "SELECT COUNT(*) FROM " + table;
            statement = db.compileStatement(query);
            numberRows = statement.simpleQueryForLong();
        }
        catch (SQLiteException e) {
            Logy.e(TAG, String.format("getNumberRows for %s failed", table), e);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.close();
        }
        return numberRows;
    }

    synchronized long getNthEventId(long n) {
        return this.getNthEventIdFromTable(EVENT_TABLE_NAME, n);
    }

    synchronized long getNthIdentifyId(long n) {
        return this.getNthEventIdFromTable(IDENTIFY_TABLE_NAME, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long getNthEventIdFromTable(String table, long n) {
        long nthEventId = -1L;
        SQLiteStatement statement = null;
        try {
            SQLiteDatabase db = this.getReadableDatabase();
            String query = "SELECT id FROM " + table + " LIMIT 1 OFFSET " + (n - 1L);
            statement = db.compileStatement(query);
            nthEventId = -1L;
            try {
                nthEventId = statement.simpleQueryForLong();
            }
            catch (SQLiteDoneException e) {
                Logy.w(TAG, e.toString());
            }
        }
        catch (SQLiteException e) {
            Logy.e(TAG, String.format("getNthEventId from %s failed", table), e);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            this.close();
        }
        return nthEventId;
    }

    synchronized void removeEvents(long maxId) {
        this.removeEventsFromTable(EVENT_TABLE_NAME, maxId);
    }

    synchronized void removeIdentifys(long maxId) {
        this.removeEventsFromTable(IDENTIFY_TABLE_NAME, maxId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeEventsFromTable(String table, long maxId) {
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            db.delete(table, "id <= " + maxId, null);
        }
        catch (SQLiteException e) {
            Logy.e(TAG, String.format("removeEvents from %s failed", table), e);
        }
        finally {
            this.close();
        }
    }

    synchronized void removeEvent(long id) {
        this.removeEventFromTable(EVENT_TABLE_NAME, id);
    }

    synchronized void removeIdentify(long id) {
        this.removeEventFromTable(IDENTIFY_TABLE_NAME, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeEventFromTable(String table, long id) {
        try {
            SQLiteDatabase db = this.getWritableDatabase();
            db.delete(table, "id = " + id, null);
        }
        catch (SQLiteException e) {
            Logy.e(TAG, String.format("removeEvent from %s failed", table), e);
        }
        finally {
            this.close();
        }
    }

    private void delete() {
        try {
            this.close();
            this.file.delete();
        }
        catch (SecurityException e) {
            Logy.e(TAG, "delete failed", e);
        }
    }
}

