package ai.botbrain.ttcloud.sdk.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import ai.botbrain.ttcloud.sdk.R;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 17/6/14.
 */

public class UpdateStateView extends RelativeLayout {

    private TextView tv_des;

    public UpdateStateView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from(context).inflate(R.layout.tsd_view_update, this);
        tv_des = (TextView) findViewById(R.id.tv_des);
    }

    public void setDes(String text) {
        tv_des.setText(text);
    }

    public void show(int count) {
        if (count > 0) {
            tv_des.setText("又更新了" + count + "条内容");
        } else {
            tv_des.setText("休息一会儿，暂无更新");
        }
        setVisibility(View.VISIBLE);
        this.postDelayed(new Runnable() {
            @Override
            public void run() {
                setVisibility(View.GONE);
            }
        }, 2000);
    }

    public void showUnknownHostException() {
        tv_des.setText("网络不可用");
        setVisibility(View.VISIBLE);
        this.postDelayed(new Runnable() {
            @Override
            public void run() {
                setVisibility(View.GONE);
            }
        }, 1000);
    }

    public void hide() {

    }
}
