package ai.botbrain.ttcloud.sdk.widget;

import android.content.Context;
import android.support.design.widget.TabLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;

import ai.botbrain.ttcloud.sdk.adapter.MyFragmentPagerAdapter;
import ai.botbrain.ttcloud.sdk.fragment.GraphicFragment;
import ai.botbrain.ttcloud.sdk.model.TopTitleEntity;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 2017/8/13.
 */

public class NewsContentPager extends ViewPager implements MyFragmentPagerAdapter.MyFragmentPagerAdapterCallBack {

    private boolean isInitTop;
    private boolean isPagingEnabled = true;
    private MyFragmentPagerAdapter myFragmentPagerAdapter;

    public NewsContentPager(Context context) {
        super(context);
        init(context);
    }

    public NewsContentPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    private void init(Context context) {

    }

    public GraphicFragment getCurrentFragment() {
        if (myFragmentPagerAdapter != null)
            return (GraphicFragment) myFragmentPagerAdapter.mCurrentFragment;
        return null;
    }

    public void setNewsAdapter(FragmentManager fragmentManager, TopTitleEntity.Data data) {
        if (!isInitTop) {
            myFragmentPagerAdapter = new MyFragmentPagerAdapter(fragmentManager, data);
            myFragmentPagerAdapter.setCallBack(this);
            setAdapter(myFragmentPagerAdapter);
            isInitTop = true;
        } else {
            //notifyDataSetChanged();
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return this.isPagingEnabled && super.onTouchEvent(event);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.isPagingEnabled && super.onInterceptTouchEvent(event);
    }

    public void setPagingEnabled(boolean b) {
        this.isPagingEnabled = b;
    }

    public void setupTabLayout(TabLayout tabLayout) {
        this.addOnPageChangeListener(new TabLayout.TabLayoutOnPageChangeListener(tabLayout));
        tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {

            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                setCurrentItem(tab.getPosition());
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {

            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });
    }

    @Override
    public void getCurrentFragment(Fragment mCurrentFragment) {
        if (null!=mCallBack && mCurrentFragment instanceof GraphicFragment) {
            mCallBack.getCurrentFragment((GraphicFragment) mCurrentFragment);
        }
    }

    private CallBack mCallBack;
    public void setCallBack(CallBack callBack) {
        mCallBack = callBack;
    }

    public interface CallBack {
        void getCurrentFragment(GraphicFragment currentFragment);
    }
}
