package ai.botbrain.ttcloud.sdk.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;

/**
 * Description：请求网络数据时ui显示的三种状态
 * 加载中，加载失败，无数据
 * Creator: Created by peter.
 * Date: 17/4/7.
 */
public class LoadingView extends FrameLayout implements View.OnClickListener {
    private View empty;
    private View error;
    private View loading;
    private State state;
    private OnRetryListener listener;

    public interface OnRetryListener {
        void onRetry();
    }

    public enum State {
        ing, error, done, empty
    }

    public LoadingView(Context context) {
        super(context);
        initializeView(context);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initializeView(context);
    }

    public LoadingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initializeView(context);
    }

    private ImageView iv_error;
    private TextView tv_1, tv_2;

    private void initializeView(Context context) {
        LayoutInflater.from(context).inflate(R.layout.tsd_widget_loading_view, this);
        empty = findViewById(R.id.empty);
        loading = findViewById(R.id.loading);
        error = findViewById(R.id.error);
        iv_error = (ImageView) findViewById(R.id.iv_error);
        tv_1 = (TextView) findViewById(R.id.tv_1);
        tv_2 = (TextView) findViewById(R.id.tv_2);
        if (0!= TsdContextHolder.getLoadingErrorView()) {
            iv_error.setImageResource(TsdContextHolder.getLoadingErrorView());
            tv_1.setVisibility(View.GONE);
            tv_2.setVisibility(View.GONE);
        }
        setOnClickListener(this);
        notifyDataChanged(State.done);
    }

    public void notifyDataChanged(State state) {
        this.state = state;
        switch (state) {
            case ing:
                setVisibility(View.VISIBLE);
                loading.setVisibility(View.VISIBLE);
                empty.setVisibility(View.GONE);
                error.setVisibility(View.GONE);
                break;
            case empty:
                setVisibility(View.VISIBLE);
                loading.setVisibility(View.GONE);
                empty.setVisibility(View.VISIBLE);
                error.setVisibility(View.GONE);
                break;
            case error:
                setVisibility(View.VISIBLE);
                loading.setVisibility(View.GONE);
                empty.setVisibility(View.GONE);
                error.setVisibility(View.VISIBLE);
                break;
            case done:
                setVisibility(View.GONE);
                break;
            default:
                break;
        }
    }

    public void setOnRetryListener(OnRetryListener listener) {
        this.listener = listener;
    }

    /*
    public void setEmptyView(View view) {
        empty.removeAllViews();
        empty.addView(view);
    }
    */

    @Override
    public void onClick(View v) {
        if (listener != null && state == State.error) {
            listener.onRetry();
        }
    }
}
