package ai.botbrain.ttcloud.sdk.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * Description：timeUtil
 * Creator: Created by peter.
 * Date: 17/3/28.
 */

public class TimeUtil {

    /**
     * Display a friendly time.
     *
     * @param dateString s
     * @return s
     */
    public static String getNiceDate(String dateString) {
        String result = dateString;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        try {
            Date date = df.parse(dateString);

            long time = System.currentTimeMillis() - date.getTime();
            time = time / 1000;

            if (time < 10) {
                result = "刚刚";
            } else if (time >= 10 && time < 60) {
                result = "一分钟之内";
            } else if (time >= 60 && time < 3600) {
                result = "一小时之内";
            } else if (time >= 3600 && time < 86400) {
                result = "今天";
            } else {
                result = getStrTimeMMDD(date.getTime() + "");
            }
        } catch (ParseException e) {
            LogUtil.e("--------友好时间展示错误------");
            e.printStackTrace();
        }

        return result;
    }

    /**
     * 时间戳转化Data
     *
     * @param time s
     * @return s
     */
    public static String getStrTimeMMDD(String time) {
        String d = "";
        try {
            SimpleDateFormat format = new SimpleDateFormat("MM-dd HH:mm", Locale.getDefault());
            Long l = Long.valueOf(time);
            d = format.format(l);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return d;
    }

    /**
     * 时间戳转化Data
     *
     * @param time s
     * @return s
     */
    public static String getStrTime(String time) {
        String d = "";
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
            Long l = Long.valueOf(time);
            d = format.format(l);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return d;
    }

    /**
     * get timestamp.
     *
     * @return timestamp.
     */
    public static String getTimestamp() {
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyyMMddhhmmss", Locale.getDefault());
        return sDateFormat.format(new java.util.Date());
    }

    public static String getTime() {
        Long longTime = new Date().getTime();
        return String.valueOf(longTime);
    }
}