package ai.botbrain.ttcloud.sdk.adapter;

import android.content.Context;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;

import java.util.List;

import ai.botbrain.ttcloud.sdk.R;
import ai.botbrain.ttcloud.sdk.activity.TsdH5ReaderActivity;
import ai.botbrain.ttcloud.sdk.model.SubCommEntity;
import ai.botbrain.ttcloud.sdk.model.SubCommentEntity;
import ai.botbrain.ttcloud.sdk.util.TsdContextHolder;
import ai.botbrain.ttcloud.sdk.util.TimeUtil;
import ai.botbrain.ttcloud.sdk.widget.TsdCircleImageView;

/**
 * Description：
 * Creator: Created by peter.
 * Date: 2017/8/1.
 */

public class SubCommentAdapter extends BaseAdapter implements View.OnClickListener {

    private Context mContext;
    private List<SubCommentEntity> mDatas;

    private RequestOptions options_avatar = new RequestOptions()
            .centerCrop()
            //.placeholder(R.drawable.tsd_def_avatar)
            .error(R.drawable.tsd_def_avatar)
            .diskCacheStrategy(DiskCacheStrategy.AUTOMATIC)
            .skipMemoryCache(false)
            .priority(Priority.HIGH);

    public SubCommentAdapter(Context context, List<SubCommentEntity> datas) {
        this.mContext = context;
        this.mDatas = datas;
    }

    @Override
    public int getCount() {
        return null == mDatas ? 0 : mDatas.size();
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        final ViewHolder viewHolder;
        if (convertView == null || convertView.getTag() == null) {
            viewHolder = new ViewHolder();
            convertView = View.inflate(mContext, R.layout.tsd_item_sub_comment, null);
            viewHolder.iv_avatar = (TsdCircleImageView) convertView.findViewById(R.id.iv_avatar);
            viewHolder.tv_user_nick = (TextView) convertView.findViewById(R.id.tv_user_nick);
            viewHolder.tv_content = (TextView) convertView.findViewById(R.id.tv_content);
            viewHolder.tv_time = (TextView) convertView.findViewById(R.id.tv_time);
            viewHolder.tv_reply = (TextView) convertView.findViewById(R.id.tv_reply);

            viewHolder.tv_reply.setOnClickListener(this);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        viewHolder.tv_reply.setTag(position);
        SubCommentEntity data = mDatas.get(position);
        String userNick = null == data.userNickName ? "" : data.userNickName;
        String userIcon = null == data.userAvatar ? "" : data.userAvatar;
        String commentContent = null == data.commentContent ? "" : data.commentContent;
        String commentTime = null == data.commentTime ? "" : data.commentTime;
        String parentNick = null == data.parentNick ? "" : data.parentNick;
        String parentCommentContent = null == data.parentCommentContent ? "" : data.parentCommentContent;
        commentTime = TimeUtil.getStrTime(commentTime);
        commentTime = TimeUtil.getNiceDate(commentTime);

        viewHolder.tv_user_nick.setText(userNick);
        if (TextUtils.isEmpty(parentCommentContent)) {
            viewHolder.tv_content.setText(commentContent);
        } else {
            viewHolder.tv_content.setText(Html.fromHtml(commentContent + " //" + "<font color='#215a94'>" + "@" + parentNick + "</font>" + "：" + parentCommentContent));
        }

        viewHolder.tv_time.setText(commentTime);
        Glide.with(TsdContextHolder.getContext()).setDefaultRequestOptions(options_avatar).load(userIcon).transition(
                new DrawableTransitionOptions().crossFade(500)).into(viewHolder.iv_avatar);

        return convertView;
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.tv_reply) {
            int position = (int) v.getTag();
            clickReply(v, position);
        }
    }

    private void clickReply(View v, int position) {
        if (!TsdContextHolder.isLogin()) {
            TsdContextHolder.getTtCloudListener().onComment(v, null, null);
            return;
        }
        TsdH5ReaderActivity h5ReaderActivity = ((TsdH5ReaderActivity) mContext);

        SubCommentEntity data = mDatas.get(position);

        SubCommEntity subCommEntity = new SubCommEntity();

        subCommEntity.parentId = data.userId;
        subCommEntity.parentIcon = data.userAvatar;
        subCommEntity.parentCommentId = data.id;
        subCommEntity.parentNick = data.userNickName;
        subCommEntity.parentCommentContent = data.commentContent;

        subCommEntity.superiorCommentId = h5ReaderActivity.mSubCommentsWidget.id;

        h5ReaderActivity.setSubCommEntity(subCommEntity);
        h5ReaderActivity.showInputDialog();
    }

    private static class ViewHolder {
        TsdCircleImageView iv_avatar;
        TextView tv_user_nick;
        TextView tv_content;
        TextView tv_time;
        TextView tv_reply;
    }
}
