/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DataForm;

public class ReportedData {
    private List columns = new ArrayList();
    private List rows = new ArrayList();
    private String title = "";

    public static ReportedData getReportedDataFrom(Packet packet) {
        DataForm dataForm;
        PacketExtension packetExtension = packet.getExtension("x", "jabber:x:data");
        if (packetExtension != null && (dataForm = (DataForm)packetExtension).getReportedData() != null) {
            return new ReportedData(dataForm);
        }
        return null;
    }

    private ReportedData(DataForm dataForm) {
        Iterator fields = dataForm.getReportedData().getFields();
        while (fields.hasNext()) {
            FormField field = (FormField)fields.next();
            this.columns.add(new Column(field.getLabel(), field.getVariable(), field.getType()));
        }
        Iterator items = dataForm.getItems();
        while (items.hasNext()) {
            DataForm.Item item = (DataForm.Item)items.next();
            ArrayList<Field> fieldList = new ArrayList<Field>(this.columns.size());
            Iterator fields2 = item.getFields();
            while (fields2.hasNext()) {
                FormField field = (FormField)fields2.next();
                fieldList.add(new Field(field.getVariable(), (String)field.getValues().next()));
            }
            this.rows.add(new Row(fieldList));
        }
        this.title = dataForm.getTitle();
    }

    public Iterator getRows() {
        return Collections.unmodifiableList(new ArrayList(this.rows)).iterator();
    }

    public Iterator getColumns() {
        return Collections.unmodifiableList(new ArrayList(this.columns)).iterator();
    }

    public String getTitle() {
        return this.title;
    }

    private static class Field {
        private String variable;
        private String value;

        private Field(String variable, String value) {
            this.variable = variable;
            this.value = value;
        }

        public String getVariable() {
            return this.variable;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Row {
        private List fields = new ArrayList();

        private Row(List fields) {
            this.fields = fields;
        }

        public String getValue(String variable) {
            Iterator it = this.getFields();
            while (it.hasNext()) {
                Field field = (Field)it.next();
                if (!variable.equals(field.getVariable())) continue;
                return field.getValue();
            }
            return null;
        }

        private Iterator getFields() {
            return Collections.unmodifiableList(new ArrayList(this.fields)).iterator();
        }
    }

    public static class Column {
        private String label;
        private String variable;
        private String type;

        private Column(String label, String variable, String type) {
            this.label = label;
            this.variable = variable;
            this.type = type;
        }

        public String getLabel() {
            return this.label;
        }

        public String getType() {
            return this.type;
        }

        public String getVariable() {
            return this.variable;
        }
    }
}

