/*
 * Decompiled with CFR 0.152.
 */
package a.yumi.lib.base.util.img;

import a.yumi.lib.base.util.img.ProgressInterceptor;
import a.yumi.lib.base.util.img.ProgressListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"La/yumi/lib/base/util/img/ProgressResponseBody;", "Lokhttp3/ResponseBody;", "url", "", "responseBody", "(Ljava/lang/String;Lokhttp3/ResponseBody;)V", "bufferedSource", "Lokio/BufferedSource;", "listener", "La/yumi/lib/base/util/img/ProgressListener;", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "source", "ProgressSource", "lib_base_release"})
public final class ProgressResponseBody
extends ResponseBody {
    private BufferedSource bufferedSource;
    private ProgressListener listener;
    private final ResponseBody responseBody;

    @Nullable
    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    @NotNull
    public BufferedSource source() {
        if (this.bufferedSource == null) {
            BufferedSource bufferedSource = this.responseBody.source();
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSource, (String)"responseBody.source()");
            this.bufferedSource = Okio.buffer((Source)((Source)new ProgressSource((Source)bufferedSource)));
        }
        BufferedSource bufferedSource = this.bufferedSource;
        if (bufferedSource == null) {
            Intrinsics.throwNpe();
        }
        return bufferedSource;
    }

    public ProgressResponseBody(@NotNull String url, @NotNull ResponseBody responseBody) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)responseBody, (String)"responseBody");
        this.responseBody = responseBody;
        this.listener = ProgressInterceptor.Companion.getLISTENER_MAP().get(url);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"La/yumi/lib/base/util/img/ProgressResponseBody$ProgressSource;", "Lokio/ForwardingSource;", "source", "Lokio/Source;", "(La/yumi/lib/base/util/img/ProgressResponseBody;Lokio/Source;)V", "currentProgress", "", "getCurrentProgress$lib_base_release", "()I", "setCurrentProgress$lib_base_release", "(I)V", "totalBytesRead", "", "getTotalBytesRead$lib_base_release", "()J", "setTotalBytesRead$lib_base_release", "(J)V", "read", "sink", "Lokio/Buffer;", "byteCount", "lib_base_release"})
    private final class ProgressSource
    extends ForwardingSource {
        private long totalBytesRead;
        private int currentProgress;

        public final long getTotalBytesRead$lib_base_release() {
            return this.totalBytesRead;
        }

        public final void setTotalBytesRead$lib_base_release(long l) {
            this.totalBytesRead = l;
        }

        public final int getCurrentProgress$lib_base_release() {
            return this.currentProgress;
        }

        public final void setCurrentProgress$lib_base_release(int n) {
            this.currentProgress = n;
        }

        public long read(@NotNull Buffer sink, long byteCount) {
            Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
            long bytesRead = super.read(sink, byteCount);
            long fullLength = ProgressResponseBody.this.responseBody.contentLength();
            this.totalBytesRead = bytesRead == -1L ? fullLength : (this.totalBytesRead += bytesRead);
            int progress = (int)(100.0f * (float)this.totalBytesRead / (float)fullLength);
            if (ProgressResponseBody.this.listener != null && progress != this.currentProgress) {
                ProgressListener progressListener = ProgressResponseBody.this.listener;
                if (progressListener != null) {
                    progressListener.onProgress(progress);
                }
            }
            if (ProgressResponseBody.this.listener != null && this.totalBytesRead == fullLength) {
                ProgressResponseBody.this.listener = null;
            }
            this.currentProgress = progress;
            return bytesRead;
        }

        public ProgressSource(Source source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super(source);
        }
    }
}

