/*
 * Decompiled with CFR 0.152.
 */
package a.yumi.lib.base.util.img;

import a.yumi.lib.base.util.ResUtil;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ProgressBar;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CircleProgressView
extends ProgressBar {
    private int mReachBarSize = ResUtil.dp2px(2.0f);
    private int mNormalBarSize = ResUtil.dp2px(2.0f);
    private int mReachBarColor = Color.parseColor((String)"#E5ffffff");
    private int mNormalBarColor = Color.parseColor((String)"#00000000");
    private int mTextSize = ResUtil.dp2px(14.0f);
    private int mTextColor = Color.parseColor((String)"#108ee9");
    private float mTextSkewX;
    private String mTextSuffix = "%";
    private String mTextPrefix = "";
    private boolean mTextVisible = true;
    private boolean mReachCapRound;
    private int mRadius = ResUtil.dp2px(20.0f);
    private int mStartArc;
    private int mInnerBackgroundColor;
    private int mProgressStyle = 2;
    private int mInnerPadding = ResUtil.dp2px(2.0f);
    private int mOuterColor;
    private boolean needDrawInnerBackground;
    private RectF rectF;
    private RectF rectInner;
    private int mOuterSize = ResUtil.dp2px(1.0f);
    private Paint mTextPaint;
    private Paint mNormalPaint;
    private Paint mReachPaint;
    private Paint mInnerBackgroundPaint;
    private Paint mOutPaint;
    private int mRealWidth;
    private int mRealHeight;
    private static final String STATE = "state";
    private static final String PROGRESS_STYLE = "progressStyle";
    private static final String TEXT_COLOR = "textColor";
    private static final String TEXT_SIZE = "textSize";
    private static final String TEXT_SKEW_X = "textSkewX";
    private static final String TEXT_VISIBLE = "textVisible";
    private static final String TEXT_SUFFIX = "textSuffix";
    private static final String TEXT_PREFIX = "textPrefix";
    private static final String REACH_BAR_COLOR = "reachBarColor";
    private static final String REACH_BAR_SIZE = "reachBarSize";
    private static final String NORMAL_BAR_COLOR = "normalBarColor";
    private static final String NORMAL_BAR_SIZE = "normalBarSize";
    private static final String IS_REACH_CAP_ROUND = "isReachCapRound";
    private static final String RADIUS = "radius";
    private static final String START_ARC = "startArc";
    private static final String INNER_BG_COLOR = "innerBgColor";
    private static final String INNER_PADDING = "innerPadding";
    private static final String OUTER_COLOR = "outerColor";
    private static final String OUTER_SIZE = "outerSize";

    public CircleProgressView(Context context) {
        this(context, null);
    }

    public CircleProgressView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.obtainAttributes(attrs);
        this.initPaint();
    }

    private void initPaint() {
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setTextSize((float)this.mTextSize);
        this.mTextPaint.setTextSkewX(this.mTextSkewX);
        this.mTextPaint.setAntiAlias(true);
        this.mNormalPaint = new Paint();
        this.mNormalPaint.setColor(this.mNormalBarColor);
        this.mNormalPaint.setStyle(this.mProgressStyle == 2 ? Paint.Style.FILL : Paint.Style.STROKE);
        this.mNormalPaint.setAntiAlias(true);
        this.mNormalPaint.setStrokeWidth((float)this.mNormalBarSize);
        this.mReachPaint = new Paint();
        this.mReachPaint.setColor(this.mReachBarColor);
        this.mReachPaint.setStyle(this.mProgressStyle == 2 ? Paint.Style.FILL : Paint.Style.STROKE);
        this.mReachPaint.setAntiAlias(true);
        this.mReachPaint.setStrokeCap(this.mReachCapRound ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        this.mReachPaint.setStrokeWidth((float)this.mReachBarSize);
        if (this.needDrawInnerBackground) {
            this.mInnerBackgroundPaint = new Paint();
            this.mInnerBackgroundPaint.setStyle(Paint.Style.FILL);
            this.mInnerBackgroundPaint.setAntiAlias(true);
            this.mInnerBackgroundPaint.setColor(this.mInnerBackgroundColor);
        }
        if (this.mProgressStyle == 2) {
            this.mOutPaint = new Paint();
            this.mOutPaint.setStyle(Paint.Style.STROKE);
            this.mOutPaint.setColor(this.mOuterColor);
            this.mOutPaint.setStrokeWidth((float)this.mOuterSize);
            this.mOutPaint.setAntiAlias(true);
        }
    }

    private void obtainAttributes(AttributeSet attrs) {
        this.mTextSkewX = 0.0f;
        this.rectF = new RectF((float)(-this.mRadius), (float)(-this.mRadius), (float)this.mRadius, (float)this.mRadius);
        switch (this.mProgressStyle) {
            case 1: {
                this.mReachBarSize = 0;
                this.mNormalBarSize = 0;
                this.mOuterSize = 0;
                break;
            }
            case 2: {
                this.mStartArc = 270;
                this.mOuterColor = this.mReachBarColor;
                this.mReachBarSize = 0;
                this.mNormalBarSize = 0;
                int mInnerRadius = this.mRadius - this.mOuterSize / 2 - this.mInnerPadding;
                this.rectInner = new RectF((float)(-mInnerRadius), (float)(-mInnerRadius), (float)mInnerRadius, (float)mInnerRadius);
                break;
            }
            case 0: {
                this.mReachCapRound = true;
                this.mStartArc = 270;
            }
        }
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int maxBarPaintWidth = Math.max(this.mReachBarSize, this.mNormalBarSize);
        int maxPaintWidth = Math.max(maxBarPaintWidth, this.mOuterSize);
        int height = 0;
        int width = 0;
        switch (this.mProgressStyle) {
            case 1: {
                height = this.getPaddingTop() + this.getPaddingBottom() + Math.abs(this.mRadius * 2);
                width = this.getPaddingLeft() + this.getPaddingRight() + Math.abs(this.mRadius * 2);
                break;
            }
            case 2: {
                height = this.getPaddingTop() + this.getPaddingBottom() + Math.abs(this.mRadius * 2) + maxPaintWidth;
                width = this.getPaddingLeft() + this.getPaddingRight() + Math.abs(this.mRadius * 2) + maxPaintWidth;
                break;
            }
            case 0: {
                height = this.getPaddingTop() + this.getPaddingBottom() + Math.abs(this.mRadius * 2) + maxBarPaintWidth;
                width = this.getPaddingLeft() + this.getPaddingRight() + Math.abs(this.mRadius * 2) + maxBarPaintWidth;
                break;
            }
        }
        this.mRealWidth = CircleProgressView.resolveSize((int)width, (int)widthMeasureSpec);
        this.mRealHeight = CircleProgressView.resolveSize((int)height, (int)heightMeasureSpec);
        this.setMeasuredDimension(this.mRealWidth, this.mRealHeight);
    }

    protected synchronized void onDraw(Canvas canvas) {
        switch (this.mProgressStyle) {
            case 0: {
                this.drawNormalCircle(canvas);
                break;
            }
            case 1: {
                this.drawFillInCircle(canvas);
                break;
            }
            case 2: {
                this.drawFillInArcCircle(canvas);
            }
        }
    }

    private void drawFillInArcCircle(Canvas canvas) {
        canvas.save();
        canvas.translate((float)(this.mRealWidth / 2), (float)(this.mRealHeight / 2));
        canvas.drawArc(this.rectF, 0.0f, 360.0f, false, this.mOutPaint);
        float reachArc = (float)this.getProgress() * 1.0f / (float)this.getMax() * 360.0f;
        canvas.drawArc(this.rectInner, (float)this.mStartArc, reachArc, true, this.mReachPaint);
        if (reachArc != 360.0f) {
            canvas.drawArc(this.rectInner, reachArc + (float)this.mStartArc, 360.0f - reachArc, true, this.mNormalPaint);
        }
        canvas.restore();
    }

    private void drawFillInCircle(Canvas canvas) {
        canvas.save();
        canvas.translate((float)(this.mRealWidth / 2), (float)(this.mRealHeight / 2));
        float progressY = (float)this.getProgress() * 1.0f / (float)this.getMax() * (float)(this.mRadius * 2);
        float angle = (float)(Math.acos(((float)this.mRadius - progressY) / (float)this.mRadius) * 180.0 / Math.PI);
        float startAngle = 90.0f + angle;
        float sweepAngle = 360.0f - angle * 2.0f;
        this.rectF = new RectF((float)(-this.mRadius), (float)(-this.mRadius), (float)this.mRadius, (float)this.mRadius);
        this.mNormalPaint.setStyle(Paint.Style.FILL);
        canvas.drawArc(this.rectF, startAngle, sweepAngle, false, this.mNormalPaint);
        canvas.rotate(180.0f);
        this.mReachPaint.setStyle(Paint.Style.FILL);
        canvas.drawArc(this.rectF, 270.0f - angle, angle * 2.0f, false, this.mReachPaint);
        canvas.rotate(180.0f);
        if (this.mTextVisible) {
            String text = this.mTextPrefix + this.getProgress() + this.mTextSuffix;
            float textWidth = this.mTextPaint.measureText(text);
            float textHeight = this.mTextPaint.descent() + this.mTextPaint.ascent();
            canvas.drawText(text, -textWidth / 2.0f, -textHeight / 2.0f, this.mTextPaint);
        }
    }

    private void drawNormalCircle(Canvas canvas) {
        float reachArc;
        canvas.save();
        canvas.translate((float)(this.mRealWidth / 2), (float)(this.mRealHeight / 2));
        if (this.needDrawInnerBackground) {
            canvas.drawCircle(0.0f, 0.0f, (float)(this.mRadius - Math.min(this.mReachBarSize, this.mNormalBarSize) / 2), this.mInnerBackgroundPaint);
        }
        if (this.mTextVisible) {
            String text = this.mTextPrefix + this.getProgress() + this.mTextSuffix;
            float textWidth = this.mTextPaint.measureText(text);
            float textHeight = this.mTextPaint.descent() + this.mTextPaint.ascent();
            canvas.drawText(text, -textWidth / 2.0f, -textHeight / 2.0f, this.mTextPaint);
        }
        if ((reachArc = (float)this.getProgress() * 1.0f / (float)this.getMax() * 360.0f) != 360.0f) {
            canvas.drawArc(this.rectF, reachArc + (float)this.mStartArc, 360.0f - reachArc, false, this.mNormalPaint);
        }
        canvas.drawArc(this.rectF, (float)this.mStartArc, reachArc, false, this.mReachPaint);
        canvas.restore();
    }

    public void runProgressAnim(long duration) {
        this.setProgressInTime(0, duration);
    }

    public void setProgressInTime(int progress, long duration) {
        this.setProgressInTime(progress, this.getProgress(), duration);
    }

    public void setProgressInTime(int startProgress, int progress, long duration) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{startProgress, progress});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                int currentValue = (Integer)animator.getAnimatedValue();
                CircleProgressView.this.setProgress(currentValue);
            }
        });
        AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        valueAnimator.setInterpolator((TimeInterpolator)interpolator);
        valueAnimator.setDuration(duration);
        valueAnimator.start();
    }

    public int getReachBarSize() {
        return this.mReachBarSize;
    }

    public void setReachBarSize(int reachBarSize) {
        this.mReachBarSize = ResUtil.dp2px(reachBarSize);
        this.invalidate();
    }

    public int getNormalBarSize() {
        return this.mNormalBarSize;
    }

    public void setNormalBarSize(int normalBarSize) {
        this.mNormalBarSize = ResUtil.dp2px(normalBarSize);
        this.invalidate();
    }

    public int getReachBarColor() {
        return this.mReachBarColor;
    }

    public void setReachBarColor(int reachBarColor) {
        this.mReachBarColor = reachBarColor;
        this.invalidate();
    }

    public int getNormalBarColor() {
        return this.mNormalBarColor;
    }

    public void setNormalBarColor(int normalBarColor) {
        this.mNormalBarColor = normalBarColor;
        this.invalidate();
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(int textSize) {
        this.mTextSize = ResUtil.dp2px(textSize);
        this.invalidate();
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTextColor(int textColor) {
        this.mTextColor = textColor;
        this.invalidate();
    }

    public float getTextSkewX() {
        return this.mTextSkewX;
    }

    public void setTextSkewX(float textSkewX) {
        this.mTextSkewX = textSkewX;
        this.invalidate();
    }

    public String getTextSuffix() {
        return this.mTextSuffix;
    }

    public void setTextSuffix(String textSuffix) {
        this.mTextSuffix = textSuffix;
        this.invalidate();
    }

    public String getTextPrefix() {
        return this.mTextPrefix;
    }

    public void setTextPrefix(String textPrefix) {
        this.mTextPrefix = textPrefix;
        this.invalidate();
    }

    public boolean isTextVisible() {
        return this.mTextVisible;
    }

    public void setTextVisible(boolean textVisible) {
        this.mTextVisible = textVisible;
        this.invalidate();
    }

    public boolean isReachCapRound() {
        return this.mReachCapRound;
    }

    public void setReachCapRound(boolean reachCapRound) {
        this.mReachCapRound = reachCapRound;
        this.invalidate();
    }

    public int getRadius() {
        return this.mRadius;
    }

    public void setRadius(int radius) {
        this.mRadius = ResUtil.dp2px(radius);
        this.invalidate();
    }

    public int getStartArc() {
        return this.mStartArc;
    }

    public void setStartArc(int startArc) {
        this.mStartArc = startArc;
        this.invalidate();
    }

    public int getInnerBackgroundColor() {
        return this.mInnerBackgroundColor;
    }

    public void setInnerBackgroundColor(int innerBackgroundColor) {
        this.mInnerBackgroundColor = innerBackgroundColor;
        this.invalidate();
    }

    public int getProgressStyle() {
        return this.mProgressStyle;
    }

    public void setProgressStyle(int progressStyle) {
        this.mProgressStyle = progressStyle;
        this.invalidate();
    }

    public int getInnerPadding() {
        return this.mInnerPadding;
    }

    public void setInnerPadding(int innerPadding) {
        this.mInnerPadding = ResUtil.dp2px(innerPadding);
        int mInnerRadius = this.mRadius - this.mOuterSize / 2 - this.mInnerPadding;
        this.rectInner = new RectF((float)(-mInnerRadius), (float)(-mInnerRadius), (float)mInnerRadius, (float)mInnerRadius);
        this.invalidate();
    }

    public int getOuterColor() {
        return this.mOuterColor;
    }

    public void setOuterColor(int outerColor) {
        this.mOuterColor = outerColor;
        this.invalidate();
    }

    public int getOuterSize() {
        return this.mOuterSize;
    }

    public void setOuterSize(int outerSize) {
        this.mOuterSize = ResUtil.dp2px(outerSize);
        this.invalidate();
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(STATE, super.onSaveInstanceState());
        bundle.putInt(PROGRESS_STYLE, this.getProgressStyle());
        bundle.putInt(RADIUS, this.getRadius());
        bundle.putBoolean(IS_REACH_CAP_ROUND, this.isReachCapRound());
        bundle.putInt(START_ARC, this.getStartArc());
        bundle.putInt(INNER_BG_COLOR, this.getInnerBackgroundColor());
        bundle.putInt(INNER_PADDING, this.getInnerPadding());
        bundle.putInt(OUTER_COLOR, this.getOuterColor());
        bundle.putInt(OUTER_SIZE, this.getOuterSize());
        bundle.putInt(TEXT_COLOR, this.getTextColor());
        bundle.putInt(TEXT_SIZE, this.getTextSize());
        bundle.putFloat(TEXT_SKEW_X, this.getTextSkewX());
        bundle.putBoolean(TEXT_VISIBLE, this.isTextVisible());
        bundle.putString(TEXT_SUFFIX, this.getTextSuffix());
        bundle.putString(TEXT_PREFIX, this.getTextPrefix());
        bundle.putInt(REACH_BAR_COLOR, this.getReachBarColor());
        bundle.putInt(REACH_BAR_SIZE, this.getReachBarSize());
        bundle.putInt(NORMAL_BAR_COLOR, this.getNormalBarColor());
        bundle.putInt(NORMAL_BAR_SIZE, this.getNormalBarSize());
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mProgressStyle = bundle.getInt(PROGRESS_STYLE);
            this.mRadius = bundle.getInt(RADIUS);
            this.mReachCapRound = bundle.getBoolean(IS_REACH_CAP_ROUND);
            this.mStartArc = bundle.getInt(START_ARC);
            this.mInnerBackgroundColor = bundle.getInt(INNER_BG_COLOR);
            this.mInnerPadding = bundle.getInt(INNER_PADDING);
            this.mOuterColor = bundle.getInt(OUTER_COLOR);
            this.mOuterSize = bundle.getInt(OUTER_SIZE);
            this.mTextColor = bundle.getInt(TEXT_COLOR);
            this.mTextSize = bundle.getInt(TEXT_SIZE);
            this.mTextSkewX = bundle.getFloat(TEXT_SKEW_X);
            this.mTextVisible = bundle.getBoolean(TEXT_VISIBLE);
            this.mTextSuffix = bundle.getString(TEXT_SUFFIX);
            this.mTextPrefix = bundle.getString(TEXT_PREFIX);
            this.mReachBarColor = bundle.getInt(REACH_BAR_COLOR);
            this.mReachBarSize = bundle.getInt(REACH_BAR_SIZE);
            this.mNormalBarColor = bundle.getInt(NORMAL_BAR_COLOR);
            this.mNormalBarSize = bundle.getInt(NORMAL_BAR_SIZE);
            this.initPaint();
            super.onRestoreInstanceState(bundle.getParcelable(STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void invalidate() {
        this.initPaint();
        super.invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProgressStyle {
        public static final int NORMAL = 0;
        public static final int FILL_IN = 1;
        public static final int FILL_IN_ARC = 2;
    }
}

