/*
 * Decompiled with CFR 0.152.
 */
package a.yumi.lib.base.http;

import a.yumi.lib.base.http.DownloadListener;
import a.yumi.lib.base.http.DownloadService;
import a.yumi.lib.base.util.log.LogUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0013\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"La/yumi/lib/base/http/DownloadUtil;", "", "()V", "sBufferSize", "", "download", "", "url", "", "path", "downloadListener", "La/yumi/lib/base/http/DownloadListener;", "writeFileFromIS", "file", "Ljava/io/File;", "is", "Ljava/io/InputStream;", "totalLength", "", "writeResponseToDisk", "response", "Lretrofit2/Response;", "Lokhttp3/ResponseBody;", "lib_base_release"})
public final class DownloadUtil {
    private static final int sBufferSize = 8192;
    public static final DownloadUtil INSTANCE;

    public final void download(@NotNull String url, @NotNull String path, @NotNull DownloadListener downloadListener) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)downloadListener, (String)"downloadListener");
        Retrofit retrofit = new Retrofit.Builder().baseUrl("http://www.xxx.com").callbackExecutor((Executor)Executors.newSingleThreadExecutor()).build();
        DownloadService service = (DownloadService)retrofit.create(DownloadService.class);
        Call<ResponseBody> call = service.download(url);
        call.enqueue((Callback)new Callback<ResponseBody>(path, downloadListener){
            final /* synthetic */ String $path;
            final /* synthetic */ DownloadListener $downloadListener;

            public void onFailure(@NotNull Call<ResponseBody> call, @NotNull Throwable t) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                LogUtil.loge("onFailure = ");
            }

            public void onResponse(@NotNull Call<ResponseBody> call, @NotNull Response<ResponseBody> response) {
                Intrinsics.checkParameterIsNotNull(call, (String)"call");
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                LogUtil.loge("onResponse");
                DownloadUtil.access$writeResponseToDisk(DownloadUtil.INSTANCE, this.$path, response, this.$downloadListener);
            }
            {
                this.$path = $captured_local_variable$0;
                this.$downloadListener = $captured_local_variable$1;
            }
        });
    }

    private final void writeResponseToDisk(String path, Response<ResponseBody> response, DownloadListener downloadListener) {
        File file = new File(path);
        Object object = response.body();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        InputStream inputStream = ((ResponseBody)object).byteStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"response.body()!!.byteStream()");
        Object object2 = response.body();
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        this.writeFileFromIS(file, inputStream, ((ResponseBody)object2).contentLength(), downloadListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void writeFileFromIS(File file, InputStream is, long totalLength, DownloadListener downloadListener) {
        block23: {
            downloadListener.onStart();
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdir();
                }
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    downloadListener.onFail("createNewFile IOException");
                }
            }
            os = null;
            currentLength = 0L;
            os = new BufferedOutputStream(new FileOutputStream(file));
            data = new byte[DownloadUtil.sBufferSize];
            len = is.read(data, 0, DownloadUtil.sBufferSize);
            while (len != -1) {
                os.write(data, 0, len);
                downloadListener.onProgress((int)((long)100 * (currentLength += (long)len) / totalLength));
                len = is.read(data, 0, DownloadUtil.sBufferSize);
            }
            v0 = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"file.absolutePath");
            downloadListener.onFinish(v0);
            ** try [egrp 2[TRYBLOCK] [1 : 181->189)] { 
lbl-1000:
            // 1 sources

            {
                is.close();
            }
lbl33:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break block23;
            catch (IOException e) {
                e.printStackTrace();
                downloadListener.onFail("IOException");
                break block23;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private DownloadUtil() {
    }

    static {
        DownloadUtil downloadUtil;
        INSTANCE = downloadUtil = new DownloadUtil();
        sBufferSize = 8192;
    }

    public static final /* synthetic */ void access$writeResponseToDisk(DownloadUtil $this, String path, Response response, DownloadListener downloadListener) {
        $this.writeResponseToDisk(path, (Response<ResponseBody>)response, downloadListener);
    }
}

