package a.yumi.lib.base.widget.swipetoload

import a.yumi.lib.base.R
import a.yumi.lib.base.util.dp2px
import a.yumi.lib.base.widget.swipetoload.decoration.SpaceItemDecoration
import android.content.Context
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.util.AttributeSet
import com.aspsine.swipetoloadlayout.OnRefreshListener
import com.aspsine.swipetoloadlayout.SwipeToLoadLayout
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.listener.OnItemClickListener
import java.lang.RuntimeException

/**
 * PS:
 * 功能定义：
 * 1、带刷新头，加载尾
 * 2、刷新头、加载尾可独立配置
 * 3、setListener 单方法
 * 4、...
 */
class YMSwipeToLoadLayout : SwipeToLoadLayout {
    companion object {
        //带分页的情况下，默认第一页的页码
        private const val DEFAULT_FIRST_PAGE_NO = 1
    }

    //初始化 页码
    private var mPageNo = DEFAULT_FIRST_PAGE_NO

    private var mIsRefreshEnabled = true
    private var mIsLoadMoreEnabled = true

    private var mAdapter: BaseQuickAdapter<*, *>? = null

    private var mListener: Listener? = null

    constructor(context: Context) : super(context) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        init()
    }

    val recyclerView: RecyclerView by lazy {
        RecyclerView(context).apply {
            id = R.id.swipe_target
            layoutManager = LinearLayoutManager(context)
        }
    }

    val headerView: YMRefreshHeaderView by lazy {
        YMRefreshHeaderView(context).apply {
            id = R.id.swipe_refresh_header
            layoutParams = LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT)
        }
    }

    private fun init() {
        addView(headerView)
        addView(recyclerView)

        setSwipeStyle(STYLE.ABOVE)
    }

    fun setAdapter(adapter: BaseQuickAdapter<*, *>, refreshEnabled: Boolean = true, loadMoreEnabled: Boolean = true) {
        // bind
        mAdapter = adapter
        adapter.openLoadAnimation()
        adapter.bindToRecyclerView(recyclerView)

        // ItemDecoration
        recyclerView.addItemDecoration(SpaceItemDecoration(dp2px(8F)))
        // refresh
        isRefreshEnabled = refreshEnabled
        mIsRefreshEnabled = refreshEnabled
        if (isRefreshEnabled) {
            setOnRefreshListener(onRefreshListener)
        } else {
            setOnRefreshListener(null)
        }
        // load more
        mIsLoadMoreEnabled = loadMoreEnabled
        if (loadMoreEnabled) {
            adapter.disableLoadMoreIfNotFullPage()
            adapter.setEnableLoadMore(true)
            adapter.setPreLoadNumber(2)
            adapter.setOnLoadMoreListener(onLoadMoreListener, recyclerView)
        } else {
            adapter.setEnableLoadMore(false)
            adapter.setOnLoadMoreListener(null, recyclerView)
        }
    }

    fun setListData(data: BaseListData<*>?) {
        mAdapter ?: throw RuntimeException("mAdapter is null , please setAdapter first")
        // 使用 data 的页码控制
        if (false) {
        } else {
            // 使用本地的页码控制
            if (data == null || data.listData.isEmpty()) {
                isRefreshing = false
                mAdapter?.loadMoreEnd()
                return
            }
            val list = data.listData as? List<Nothing> ?: return
            when (mPageNo) {
                1 -> {
                    mAdapter?.setNewData(list)
                    isRefreshing = false
                }
                else -> {
                    mAdapter?.addData(list)
                    mAdapter?.loadMoreComplete()
                }
            }
        }
    }

    fun autoRefresh() {
        mAdapter ?: throw RuntimeException("mAdapter is null , please setAdapter first")
        isRefreshing = true
    }

    fun setLayoutManager(layout: RecyclerView.LayoutManager) {
        recyclerView.layoutManager = layout
    }

    fun setListener(listener: Listener) {
        mListener = listener
    }

    fun addOnItemListener(onItemClickListener: OnItemClickListener) {
        recyclerView.addOnItemTouchListener(onItemClickListener)
    }

    private val onRefreshListener = OnRefreshListener {
        mPageNo = DEFAULT_FIRST_PAGE_NO
        mListener?.getDataByPage(mPageNo - 1, mPageNo)
    }

    private val onLoadMoreListener = BaseQuickAdapter.RequestLoadMoreListener {
        mPageNo++
        mListener?.getDataByPage(mPageNo - 1, mPageNo)
    }

    interface Listener {
        fun getDataByPage(page0: Int, page1: Int)
    }
}

abstract class BaseListData<T> {
    /** 每页数量 */
    abstract val pageSize: Int
    /** 当前页码 */
    abstract val nowPage: Int
    /** 总数量 */
    abstract val totalSize: Int
    /** 总页数 */
    abstract val totalPage: Int
    /** 数据 */
    abstract val listData: List<T>
}