@file:JvmMultifileClass
@file:JvmName("JsonUtil")

package a.yumi.lib.base.util.json

import a.yumi.lib.base.util.log.loge
import android.support.annotation.Keep
import com.google.gson.Gson
import java.lang.reflect.Type

@Keep
fun Any?.toJson(): String {
    if (this == null) {
        return ""
    }
    var jsonStr = ""
    try {
        jsonStr = Gson().toJson(this) //现在替换为Gson
    } catch (e: Exception) {
        loge(e)
    }
    return jsonStr
}

@Keep
infix fun <T> String?.toJson(parseClass: Class<T>): T? {
    var t: T? = null
    try {
        t = Gson().fromJson(this, parseClass) //现在替换为Gson
    } catch (e: Exception) {
        loge(e)
    }
    return t
}

@Keep
infix fun <T> String?.toJson(type: Type): T? {
    var t: T? = null
    try {
        t = Gson().fromJson(this, type) //现在替换为Gson
    } catch (e: Exception) {
        loge(e)
    }
    return t
}

@Keep
infix fun <T> String?.toJsonArray(parseClass: Class<T>): MutableList<T>? {
    var t: MutableList<T>? = null
    try {
        val listType = ParameterizedTypeImpl(MutableList::class.java, arrayOf(parseClass)) //现在替换为Gson
        t = Gson().fromJson(this, listType)
    } catch (e: Exception) {
        loge(e)
    }
    return t
}

@Keep
fun Any?.toMap(): Map<*, *> {
    return this.toJson().toJson(Map::class.java) as Map<*, *>
}