@file:JvmMultifileClass
@file:JvmName("ImageUtil")

package a.yumi.lib.base.util.img

import a.yumi.lib.base.R
import a.yumi.lib.base.util.log.loge
import android.content.Context
import android.graphics.drawable.Drawable
import android.support.annotation.DrawableRes
import android.widget.ImageView
import com.bumptech.glide.load.DataSource
import com.bumptech.glide.load.engine.GlideException
import com.bumptech.glide.request.RequestListener
import com.bumptech.glide.request.target.Target
import java.io.File

private fun getGlide(context: Context): GlideRequests {
    return GlideApp.with(context)
}

// ------------------loadUrl--------------------------------------------------------------------------------------------

@JvmOverloads
fun ImageView.loadUrl(
    url: String,
    @DrawableRes placeholder: Int = 0,
    @DrawableRes error: Int = R.drawable.ymui_base_image_preview_error,
    onLoadFailed1: () -> Unit = {},
    onResourceReady1: () -> Unit = {}
) {
    getGlide(context)
        .load(url)
        .myOption()
        .listener(object : RequestListener<Drawable> {
            override fun onLoadFailed(
                e: GlideException?,
                model: Any?,
                target: Target<Drawable>?,
                isFirstResource: Boolean
            ): Boolean {
                loge("loadUrl onLoadFailed url = $url")
                ProgressInterceptor.removeListener(url)
                onLoadFailed1()
                return false
            }

            override fun onResourceReady(
                resource: Drawable?,
                model: Any?,
                target: Target<Drawable>?,
                dataSource: DataSource?,
                isFirstResource: Boolean
            ): Boolean {
//                loge("loadUrl onResourceReady url = $url")
                ProgressInterceptor.removeListener(url)
                onResourceReady1()
                return false
            }
        })
        .placeholder(placeholder)
        .error(error)
        .dontAnimate()
        .into(this)
}

// ------------------loadRes--------------------------------------------------------------------------------------------

@JvmOverloads
fun ImageView.loadRes(
    @DrawableRes res: Int,
    @DrawableRes placeholder: Int = 0,
    @DrawableRes error: Int = 0
) {
    getGlide(context)
        .load(res)
        .placeholder(placeholder)
        .error(error)
        .dontAnimate()
        .into(this)
}

// ------------------loadFile--------------------------------------------------------------------------------------------

@JvmOverloads
fun ImageView.loadFile(
    file: String,
    @DrawableRes placeholder: Int = 0,
    @DrawableRes error: Int = 0
) {
    getGlide(context)
        .load("file://$file")
        .placeholder(placeholder)
        .error(error)
        .dontAnimate()
        .into(this)
}

@JvmOverloads
fun ImageView.loadFile(
    file: File,
    @DrawableRes placeholder: Int = 0,
    @DrawableRes error: Int = 0
) {
    getGlide(context)
        .load(file)
        .placeholder(placeholder)
        .error(error)
        .dontAnimate()
        .into(this)
}

// ------------------loadRes--------------------------------------------------------------------------------------------

@JvmOverloads
fun ImageView.loadGif(
    @DrawableRes gifResId: Int,
    @DrawableRes placeholder: Int = 0
) {
    getGlide(context)
        .asGif()
        .load(gifResId)
//        .asGif() //只能加载gif， 加载其他的报错，当然也可以不设置asGif，同样可以加载gif
//                .diskCacheStrategy(DiskCacheStrategy.SOURCE)
        .placeholder(placeholder)
        .dontAnimate()
        .into(this)
}