package a.yumi.lib.base.ui.preview

import android.content.Context
import android.support.v4.view.ViewPager
import android.util.AttributeSet
import android.view.MotionEvent

/**
 * https://github.com/chrisbanes/PhotoView
 * There are some ViewGroups (ones that utilize onInterceptTouchEvent)
 * that throw exceptions when a PhotoView is placed within them,
 * most notably ViewPager and DrawerLayout. This is a framework issue
 * that has not been resolved. In order to prevent this
 * exception (which typically occurs when you zoom out),
 * take a look at HackyDrawerLayout and you can see the solution is to simply
 * catch the exception. Any ViewGroup which uses onInterceptTouchEvent will
 * also need to be extended and exceptions caught. Use the HackyDrawerLayout
 * as a template of how to do so. The basic implementation is:
 * 有一些ViewGroups（那些利用onintercepttouchevent），
 * 抛出异常时PhotoView放置在他们，尤其是viewpager和DrawerLayout。
 * 这是一个尚未解决的框架问题。为了防止这种例外（这通常发生在当你缩小），
 * 看看HackyDrawerLayout，你可以看到解决方案是简单地捕捉异常。
 * 任何使用onintercepttouchevent ViewGroup也需要扩展和捕获的异常。
 * 使用hackydrawerlayout为模板怎么做。基本实现是：
 * Created by SHEN on 2017/11/13.
 */
class ImagePreviewViewPager : ViewPager {
    constructor(context: Context) : super(context)
    constructor(context: Context, attrs: AttributeSet) : super(context, attrs)

    override fun onInterceptTouchEvent(ev: MotionEvent): Boolean {
        return try {
            super.onInterceptTouchEvent(ev)
        } catch (e: IllegalArgumentException) {
            //uncomment if you really want to see these errors
            //e.printStackTrace();
            false
        }
    }
}