package a.yumi.lib.base.ui.activity

import android.content.pm.ActivityInfo
import android.graphics.Color
import android.os.Bundle
import android.support.annotation.LayoutRes
import android.view.View
import android.view.ViewGroup
import android.view.Window
import android.view.WindowManager
import com.alibaba.android.arouter.launcher.ARouter
import com.jaeger.library.StatusBarUtil
import com.jakewharton.rxbinding2.view.RxView
import com.trello.rxlifecycle2.components.support.RxAppCompatActivity
import io.reactivex.Observable
import java.util.concurrent.TimeUnit

/**
 * PS:
 * Created by sdx on 2019/4/17.
 */
abstract class BaseActivity : BaseScopeActivity() {
    protected val TAG = this@BaseActivity::class.java.simpleName

    protected open var defaultWindowDuration: Long = 500 //默认点击间隔

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        init()
        setContentView(getLayout())
        initStatus()
        bindView(savedInstanceState)
        initData()
    }

    private fun init() {
        window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN or WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN)
        requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_PORTRAIT

        ARouter.getInstance().inject(this)
    }

    private fun bindClickEventOb(v: View): Observable<*> {
        return RxView.clicks(v)
            .throttleFirst(defaultWindowDuration, TimeUnit.MILLISECONDS)
            .compose(bindToLifecycle())
    }

    protected fun bindClickEvent(v: View) {
        bindClickEventOb(v).subscribe { onSingleClick(v) }
    }

    protected open fun initStatus() {
        StatusBarUtil.setLightMode(this)
        StatusBarUtil.setColor(this, Color.WHITE, 0)
        val view = findViewById<View>(Window.ID_ANDROID_CONTENT)
        if (view is ViewGroup) {
            if (view.childCount > 0) {
                view.getChildAt(0).fitsSystemWindows = true
            }
        }
    }

    protected open fun onSingleClick(v: View) {}

    @LayoutRes
    protected abstract fun getLayout(): Int

    protected abstract fun bindView(bundle: Bundle?)

    protected abstract fun initData()
}