package a.yumi.lib.base.frame.mvp

import a.yumi.lib.base.ui.activity.BaseActivity
import a.yumi.lib.base.ui.YMProgressDialog

/**
 * PS:
 * Created by sdx on 2019-04-28.
 */
abstract class BaseMVPActivity<V : BaseMVPView, P : BaseMVPPresenter<V>> : BaseActivity(), BaseMVPView {
    private val progressDialog by lazy { YMProgressDialog() }

    /**
     * presenter
     */
    protected val mPresenter: P? by lazy {
        initPresenter()
    }

    /**
     * 初始化 presenter
     */
    abstract fun initPresenter(): P?

    override fun showProgress() {
        progressDialog.show(this)
    }

    override fun hideProgress() {
        progressDialog.dismiss()
    }

    override fun destroy() {
    }
}