package a.yumi.lib.base.bus

import a.yumi.lib.base.util.log.loge
import android.arch.lifecycle.LifecycleOwner
import android.arch.lifecycle.LiveData
import android.arch.lifecycle.MutableLiveData
import android.arch.lifecycle.Observer


/**
 * PS:
 * @author Created by sdx on 2019-07-22.
 */
object YLiveDataBus {
    private val bus: MutableMap<String, MutableLiveData<*>> = HashMap()

    fun <T> with(key: String, type: Class<T>): MutableLiveData<T> {
        if (!bus.containsKey(key)) {
            bus[key] = BusMutableLiveData<T>()
        }
        return bus[key] as MutableLiveData<T>
    }

    private class ObserverWrapper<T>(
        private var observer: Observer<T>
    ) : Observer<T> {
        override fun onChanged(t: T?) {
            if (isCallOnObserve()) {
                return
            }
            observer.onChanged(t)
        }

        private fun isCallOnObserve(): Boolean {
            val stackTrace = Thread.currentThread().stackTrace
            stackTrace?.forEach {
                if (it.className == "android.arch.lifecycle.LiveData" && it.methodName == "observeForever") {
                    return true
                }
            }
            return false
        }
    }

    private class BusMutableLiveData<T> : MutableLiveData<T>() {

        private val observerMap = HashMap<Observer<*>, Observer<*>>()

        override fun observe(owner: LifecycleOwner, observer: Observer<T>) {
            super.observe(owner, observer)
            try {
                hook(observer)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }

        override fun observeForever(observer: Observer<T>) {
            loge("observeForever ${observerMap.size}")
            if (!observerMap.containsKey(observer)) {
                observerMap[observer] = ObserverWrapper(observer)
            }
            super.observeForever(observerMap[observer] as Observer<T>)
        }

        override fun removeObserver(observer: Observer<T>) {
            val realObserver: Observer<T> = if (observerMap.containsKey(observer)) {
                observerMap.remove(observer) as Observer<T>
            } else {
                observer
            }
            super.removeObserver(realObserver)
        }

        @Throws
        private fun hook(observer: Observer<T>) {
            val liveDataClass = LiveData::class.java
            val fieldObservers = liveDataClass.getDeclaredField("mObservers")
            fieldObservers.isAccessible = true
            val observers = fieldObservers.get(this)
            val classObservers = observers.javaClass
            val methodGet = classObservers.getDeclaredMethod("get", Any::class.java)
            methodGet.isAccessible = true
            val objectWrapperEntry = methodGet.invoke(observers, observer)
            var objectWrapper: Any? = null
            if (objectWrapperEntry is Map.Entry<*, *>) {
                objectWrapper = objectWrapperEntry.value
            }
            if (objectWrapper == null) {
                throw  NullPointerException("Wrapper can not be bull!")
            }
            val observerWrapperClass = objectWrapper.javaClass.superclass
            val fieldLastVersion = observerWrapperClass.getDeclaredField("mLastVersion")
            fieldLastVersion.isAccessible = true
            val fieldVersion = liveDataClass.getDeclaredField("mVersion")
            fieldVersion.isAccessible = true
            val objectVersion = fieldVersion.get(this)
            fieldLastVersion.set(objectWrapper, objectVersion)
        }
    }
}