package a.yumi.lib.base

import a.yumi.lib.base.util.json.toJson
import a.yumi.lib.base.util.log.initLogUtil
import a.yumi.lib.base.util.log.logJson
import a.yumi.lib.base.util.log.loge
import android.app.ActivityManager
import android.app.Application
import android.content.Context
import android.support.annotation.Keep
import android.support.multidex.MultiDexApplication
import android.text.TextUtils
import com.alibaba.android.arouter.launcher.ARouter
import com.squareup.leakcanary.LeakCanary
import com.tencent.bugly.crashreport.CrashReport
import kotlin.properties.Delegates

/**
 * PS:
 * Created by sdx on 2018/7/6.
 */
@Keep
open class BaseApplication : MultiDexApplication() {

    companion object {
        @JvmStatic
        var context: Application by Delegates.notNull()

        private val APP_NAME = "a.yumi.module.test"
    }

    override fun onCreate() {
        super.onCreate()
        context = this
        initBaseApplication()
//        isAppMainProcess()
//        val myPid = android.os.Process.myPid()
//        loge("myPid = $myPid")
    }

    private fun initBaseApplication() {
        ARouter.openLog() // 开启日志
        ARouter.openDebug() // 使用InstantRun的时候，需要打开该开关，上线之后关闭，否则有安全风险
        ARouter.printStackTrace() // 打印日志的时候打印线程堆栈
        ARouter.init(this)
        CrashReport.initCrashReport(this, "bf3f1651d4", true)
        initLogUtil(true, "Yumi")
        try {
            LeakCanary.install(this)
        } catch (e: Exception) {

        }
    }

    fun getAppNameByPID(context: Context, pid: Int): String {
        val manager = context.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager

        for (processInfo in manager.runningAppProcesses) {
            logJson(processInfo)
//            loge("processInfo = $processInfo")
            if (processInfo.pid == pid) {
                return processInfo.processName
            }
        }
        return ""
    }

    /**
     * 判断是否是主进程
     * @return
     */
    fun isAppMainProcess(): Boolean {
        try {
            val pid = android.os.Process.myPid()
            val process = getAppNameByPID(applicationContext, pid)
            return TextUtils.isEmpty(process) || APP_NAME == process
        } catch (e: Exception) {
            return true
        }

    }
}