package a.yumi.lib.base.widget.toolbar

import a.yumi.lib.base.R
import android.app.Activity
import android.content.Context
import android.graphics.Color
import android.support.constraint.ConstraintLayout
import android.util.AttributeSet
import android.view.View
import android.view.View.OnClickListener
import kotlinx.android.synthetic.main.ym_widget_toolbar.view.*

/**
 * PS:
 * Created by sdx on 2019-04-22.
 */
class YMToolbar : ConstraintLayout {

    private var mTitleStr = "Title"
    private var mHideBack = false

    constructor(context: Context) : super(context) {
        init(null)
    }

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
        init(attrs)
    }

    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        init(attrs)
    }

    private fun init(attrs: AttributeSet?) {
        attrs?.apply {
            val a = context.obtainStyledAttributes(this, R.styleable.YMToolbar)
            mTitleStr = a.getString(R.styleable.YMToolbar_ym_toolbar_title) ?: "Title"
            mHideBack = a.getBoolean(R.styleable.YMToolbar_ym_toolbar_hide_back, false)
            a.recycle()
        }
        setBackgroundColor(Color.WHITE)
        View.inflate(context, R.layout.ym_widget_toolbar, this)

        if (mHideBack) {
            img_back.visibility = View.GONE
        }
        img_back.setOnClickListener(onClickListener)

        tv_title.text = mTitleStr
    }

    private val onClickListener = OnClickListener {
        when (it.id) {
            R.id.img_back -> {
                val lContext = context
                if (lContext is Activity) {
                    lContext.finish()
                }
            }
        }
    }

    fun setTitle(title: String) {
        tv_title.text = title
    }
}