package a.yumi.lib.base.ui.simple

import a.yumi.lib.base.R
import a.yumi.lib.base.frame.mvp.BaseMVPActivity
import a.yumi.lib.base.util.log.loge
import a.yumi.lib.router.RouterConfig
import a.yumi.lib.router.RouterUtil
import android.os.Bundle
import com.alibaba.android.arouter.facade.annotation.Autowired
import com.alibaba.android.arouter.facade.annotation.Route
import com.alibaba.android.arouter.facade.service.AutowiredService
import com.alibaba.android.arouter.launcher.ARouter

/**
 * PS:
 * @author Created by sdx on 2019-07-05.
 */
@Route(path = RouterConfig.Simple.Fragment)
class SimpleFragmentActivity : BaseMVPActivity<Nothing, Nothing>() {

    @Autowired(name = "router")
    @JvmField
    var router: String? = null

    override fun initPresenter(): Nothing? = null

    override fun getLayout(): Int = R.layout.ym_simple_fragment_activity

    override fun bindView(bundle: Bundle?) {
    }

    override fun initData() {
        val stringExtra = intent.getStringExtra("router")

        loge("getStringExtra = $stringExtra , router = $router")

        val fragment = RouterUtil.navigationFragment(router)
        fragment ?: return
        val supportFragmentManager = supportFragmentManager
        val fragmentTransaction = supportFragmentManager.beginTransaction()
        fragmentTransaction.add(R.id.fragment, fragment)
        fragmentTransaction.hide(fragment)
        fragmentTransaction.show(fragment)
        fragmentTransaction.commit()
    }
}