package a.yumi.lib.base.ui.preview

import a.yumi.lib.base.R
import a.yumi.lib.base.ui.BaseActivity
import a.yumi.lib.base.util.img.CircleProgressView
import a.yumi.lib.base.util.img.ProgressInterceptor
import a.yumi.lib.base.util.img.ProgressListener
import a.yumi.lib.base.util.img.loadUrl
import a.yumi.lib.base.util.log.logJson
import a.yumi.lib.base.util.log.loge
import a.yumi.lib.router.RouterConfig
import android.os.Bundle
import android.support.v4.view.PagerAdapter
import android.support.v4.view.ViewPager
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.alibaba.android.arouter.facade.annotation.Autowired
import com.alibaba.android.arouter.facade.annotation.Route
import com.github.chrisbanes.photoview.PhotoView
import kotlinx.android.synthetic.main.ym_image_preview_activity.*


/**
 * PS:
 * @author Created by sdx on 2019-07-08.
 */
@Route(path = RouterConfig.Simple.ImagePreview)
class ImagePreviewActivity : BaseActivity() {

    @Autowired
    @JvmField
    var imgs: ArrayList<String>? = null

    override fun getLayout(): Int = R.layout.ym_image_preview_activity

    override fun bindView(bundle: Bundle?) {
        pager.adapter = AdapterViewpager()
        pager.addOnPageChangeListener(object : ViewPager.OnPageChangeListener {
            override fun onPageScrollStateChanged(state: Int) {
            }

            override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {
            }

            override fun onPageSelected(position: Int) {
            }
        })
        pager.currentItem = 0
    }

    override fun initData() {
        logJson(imgs)
    }

    inner class AdapterViewpager : PagerAdapter() {

        override fun getCount(): Int = imgs?.size ?: 0

        override fun isViewFromObject(view: View, `object`: Any): Boolean = view === `object`

        override fun getItemPosition(`object`: Any): Int = POSITION_NONE

        override fun instantiateItem(container: ViewGroup, position: Int): Any {
            val view = LayoutInflater.from(this@ImagePreviewActivity)
                .inflate(R.layout.ym_image_preview_pager_item, container, false)

            val photoView = view.findViewById<PhotoView>(R.id.photo_view)
            val progressView = view.findViewById<CircleProgressView>(R.id.progressView1)
            progressView.progress = 1
            progressView.visibility = View.VISIBLE
            val imageData = imgs?.get(position)
            ProgressInterceptor.addListener(imageData ?: "", object : ProgressListener {
                override fun onProgress(progress: Int) {
                    runOnUiThread {
                        progressView.progress = progress
                    }
                    loge("onProgress position = $position , progress = $progress")
                }
            })
            photoView.loadUrl(imageData ?: "", onLoadFailed1 = {
                progressView.visibility = View.GONE
            }, onResourceReady1 = {
                progressView.visibility = View.GONE
            })

            container.addView(view)
            return view
        }

        override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
            container.removeView(`object` as View)
        }
    }
}