/*
 * Decompiled with CFR 0.152.
 */
package za.co.absa.hyperdrive.trigger.api.rest.services;

import java.io.Serializable;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import za.co.absa.hyperdrive.trigger.api.rest.services.DagInstanceService;
import za.co.absa.hyperdrive.trigger.api.rest.services.JobTemplateService;
import za.co.absa.hyperdrive.trigger.api.rest.services.UserDetailsService;
import za.co.absa.hyperdrive.trigger.api.rest.services.WorkflowService;
import za.co.absa.hyperdrive.trigger.api.rest.services.WorkflowValidationService;
import za.co.absa.hyperdrive.trigger.configuration.application.GeneralConfig;
import za.co.absa.hyperdrive.trigger.models.DagDefinitionJoined;
import za.co.absa.hyperdrive.trigger.models.JobDefinition;
import za.co.absa.hyperdrive.trigger.models.JobDefinitionParameters;
import za.co.absa.hyperdrive.trigger.models.JobTemplate;
import za.co.absa.hyperdrive.trigger.models.Project;
import za.co.absa.hyperdrive.trigger.models.ProjectInfo;
import za.co.absa.hyperdrive.trigger.models.Sensor;
import za.co.absa.hyperdrive.trigger.models.SensorProperties;
import za.co.absa.hyperdrive.trigger.models.Workflow;
import za.co.absa.hyperdrive.trigger.models.WorkflowImportExportWrapper;
import za.co.absa.hyperdrive.trigger.models.WorkflowJoined;
import za.co.absa.hyperdrive.trigger.models.errors.ApiError;
import za.co.absa.hyperdrive.trigger.models.errors.ApiException;
import za.co.absa.hyperdrive.trigger.models.errors.BulkOperationError;
import za.co.absa.hyperdrive.trigger.models.errors.BulkOperationError$;
import za.co.absa.hyperdrive.trigger.models.errors.GenericError;
import za.co.absa.hyperdrive.trigger.models.errors.GenericError$;
import za.co.absa.hyperdrive.trigger.models.search.TableSearchRequest;
import za.co.absa.hyperdrive.trigger.models.search.TableSearchResponse;
import za.co.absa.hyperdrive.trigger.persistance.DagInstanceRepository;
import za.co.absa.hyperdrive.trigger.persistance.WorkflowRepository;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ScalaSignature(bytes="\u0006\u0001\t]e\u0001\u0002\u0013&\u0001YB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t%\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\r\"AQ\n\u0001BC\u0002\u0013\u0005c\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003P\u0011!\u0019\u0006A!b\u0001\n\u0003\"\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011e\u0003!Q1A\u0005BiC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0017\u0005\t?\u0002\u0011)\u0019!C!A\"AA\r\u0001B\u0001B\u0003%\u0011\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003g\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u001d9\bA1A\u0005\naDq!a\u0001\u0001A\u0003%\u0011\u0010C\u0004\u0002\u0006\u0001!\t!a\u0002\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\t9\u000b\u0001C\u0001\u0003SCq!!/\u0001\t\u0003\nY\fC\u0004\u0002D\u0002!I!!2\t\u000f\u00055\u0007\u0001\"\u0011\u0002P\"9\u0011q\u001b\u0001\u0005B\u0005e\u0007bBAu\u0001\u0011\u0005\u00131\u001e\u0005\b\u0003s\u0004A\u0011IA~\u0011\u001d\u0011Y\u0001\u0001C!\u0005\u001bAqA!\b\u0001\t\u0003\u0012y\u0002C\u0004\u0003*\u0001!\tEa\u000b\t\u000f\te\u0002\u0001\"\u0011\u0003<!9!Q\n\u0001\u0005B\t=\u0003b\u0002B/\u0001\u0011\u0005#q\f\u0005\b\u0005S\u0002A\u0011\u0002B6\u0011\u001d\u0011\u0019\b\u0001C\u0005\u0005kBqA! \u0001\t\u0013\u0011yHA\nX_J\\g\r\\8x'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002'O\u0005A1/\u001a:wS\u000e,7O\u0003\u0002)S\u0005!!/Z:u\u0015\tQ3&A\u0002ba&T!\u0001L\u0017\u0002\u000fQ\u0014\u0018nZ4fe*\u0011afL\u0001\u000bQf\u0004XM\u001d3sSZ,'B\u0001\u00192\u0003\u0011\t'm]1\u000b\u0005I\u001a\u0014AA2p\u0015\u0005!\u0014A\u0001>b\u0007\u0001\u0019B\u0001A\u001c>\u0003B\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t1\u0011I\\=SK\u001a\u0004\"AP \u000e\u0003\u0015J!\u0001Q\u0013\u0003\u001f]{'o\u001b4m_^\u001cVM\u001d<jG\u0016\u0004\"A\u0010\"\n\u0005\r+#AE+tKJ$U\r^1jYN\u001cVM\u001d<jG\u0016\f!c^8sW\u001adwn\u001e*fa>\u001c\u0018\u000e^8ssV\ta\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002JW\u0005Y\u0001/\u001a:tSN$\u0018M\\2f\u0013\tY\u0005J\u0001\nX_J\\g\r\\8x%\u0016\u0004xn]5u_JL\u0018aE<pe.4Gn\\<SKB|7/\u001b;pef\u0004\u0013!\u00063bO&s7\u000f^1oG\u0016\u0014V\r]8tSR|'/_\u000b\u0002\u001fB\u0011q\tU\u0005\u0003#\"\u0013Q\u0003R1h\u0013:\u001cH/\u00198dKJ+\u0007o\\:ji>\u0014\u00180\u0001\feC\u001eLen\u001d;b]\u000e,'+\u001a9pg&$xN]=!\u0003I!\u0017mZ%ogR\fgnY3TKJ4\u0018nY3\u0016\u0003U\u0003\"A\u0010,\n\u0005]+#A\u0005#bO&s7\u000f^1oG\u0016\u001cVM\u001d<jG\u0016\f1\u0003Z1h\u0013:\u001cH/\u00198dKN+'O^5dK\u0002\n!C[8c)\u0016l\u0007\u000f\\1uKN+'O^5dKV\t1\f\u0005\u0002?9&\u0011Q,\n\u0002\u0013\u0015>\u0014G+Z7qY\u0006$XmU3sm&\u001cW-A\nk_\n$V-\u001c9mCR,7+\u001a:wS\u000e,\u0007%A\rx_J\\g\r\\8x-\u0006d\u0017\u000eZ1uS>t7+\u001a:wS\u000e,W#A1\u0011\u0005y\u0012\u0017BA2&\u0005e9vN]6gY><h+\u00197jI\u0006$\u0018n\u001c8TKJ4\u0018nY3\u00025]|'o\u001b4m_^4\u0016\r\\5eCRLwN\\*feZL7-\u001a\u0011\u0002\u001b\u001d,g.\u001a:bY\u000e{gNZ5h!\t9G.D\u0001i\u0015\tI'.A\u0006baBd\u0017nY1uS>t'BA6,\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011Q\u000e\u001b\u0002\u000e\u000f\u0016tWM]1m\u0007>tg-[4\u0002\rqJg.\u001b;?)\u001d\u0001\u0018O]:ukZ\u0004\"A\u0010\u0001\t\u000b\u0011c\u0001\u0019\u0001$\t\u000b5c\u0001\u0019A(\t\u000bMc\u0001\u0019A+\t\u000bec\u0001\u0019A.\t\u000b}c\u0001\u0019A1\t\u000b\u0015d\u0001\u0019\u00014\u0002\u001bM,'O^5dK2{wmZ3s+\u0005I\bC\u0001>\u0000\u001b\u0005Y(B\u0001?~\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0018aA8sO&\u0019\u0011\u0011A>\u0003\r1{wmZ3s\u00039\u0019XM\u001d<jG\u0016dunZ4fe\u0002\nab\u0019:fCR,wk\u001c:lM2|w\u000f\u0006\u0003\u0002\n\u00055B\u0003BA\u0006\u0003G\u0001b!!\u0004\u0002\u0014\u0005]QBAA\b\u0015\r\t\t\"O\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u000b\u0003\u001f\u0011aAR;ukJ,\u0007\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005u1&\u0001\u0004n_\u0012,Gn]\u0005\u0005\u0003C\tYB\u0001\bX_J\\g\r\\8x\u0015>Lg.\u001a3\t\u000f\u0005\u0015r\u0002q\u0001\u0002(\u0005\u0011Qm\u0019\t\u0005\u0003\u001b\tI#\u0003\u0003\u0002,\u0005=!\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u001d\tyc\u0004a\u0001\u0003/\t\u0001b^8sW\u001adwn^\u0001\fO\u0016$xk\u001c:lM2|w\u000f\u0006\u0003\u00026\u0005eB\u0003BA\u0006\u0003oAq!!\n\u0011\u0001\b\t9\u0003C\u0004\u0002<A\u0001\r!!\u0010\u0002\u0005%$\u0007c\u0001\u001d\u0002@%\u0019\u0011\u0011I\u001d\u0003\t1{gnZ\u0001\rO\u0016$xk\u001c:lM2|wo\u001d\u000b\u0003\u0003\u000f\"B!!\u0013\u0002jA1\u0011QBA\n\u0003\u0017\u0002b!!\u0014\u0002^\u0005\rd\u0002BA(\u00033rA!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+*\u0014A\u0002\u001fs_>$h(C\u0001;\u0013\r\tY&O\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty&!\u0019\u0003\u0007M+\u0017OC\u0002\u0002\\e\u0002B!!\u0007\u0002f%!\u0011qMA\u000e\u0005!9vN]6gY><\bbBA\u0013#\u0001\u000f\u0011qE\u0001\u0010g\u0016\f'o\u00195X_J\\g\r\\8xgR!\u0011qNAA)\u0011\t\t(a \u0011\r\u00055\u00111CA:!\u0019\t)(a\u001f\u0002d5\u0011\u0011q\u000f\u0006\u0005\u0003s\nY\"\u0001\u0004tK\u0006\u00148\r[\u0005\u0005\u0003{\n9HA\nUC\ndWmU3be\u000eD'+Z:q_:\u001cX\rC\u0004\u0002&I\u0001\u001d!a\n\t\u000f\u0005\r%\u00031\u0001\u0002\u0006\u0006i1/Z1sG\"\u0014V-];fgR\u0004B!!\u001e\u0002\b&!\u0011\u0011RA<\u0005I!\u0016M\u00197f'\u0016\f'o\u00195SKF,Xm\u001d;\u00023\u001d,GoV8sW\u001adwn^:CsB\u0013xN[3di:\u000bW.\u001a\u000b\u0005\u0003\u001f\u000b\u0019\n\u0006\u0003\u0002J\u0005E\u0005bBA\u0013'\u0001\u000f\u0011q\u0005\u0005\b\u0003+\u001b\u0002\u0019AAL\u0003-\u0001(o\u001c6fGRt\u0015-\\3\u0011\t\u0005e\u0015\u0011\u0015\b\u0005\u00037\u000bi\nE\u0002\u0002ReJ1!a(:\u0003\u0019\u0001&/\u001a3fM&!\u00111UAS\u0005\u0019\u0019FO]5oO*\u0019\u0011qT\u001d\u0002\u001d\u0011,G.\u001a;f/>\u00148N\u001a7poR!\u00111VA\\)\u0011\ti+!.\u0011\r\u00055\u00111CAX!\rA\u0014\u0011W\u0005\u0004\u0003gK$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003K!\u00029AA\u0014\u0011\u001d\tY\u0004\u0006a\u0001\u0003{\ta\"\u001e9eCR,wk\u001c:lM2|w\u000f\u0006\u0003\u0002>\u0006\u0005G\u0003BA\u0006\u0003\u007fCq!!\n\u0016\u0001\b\t9\u0003C\u0004\u00020U\u0001\r!a\u0006\u000235,'oZ3XSRDwJ]5hS:\fGnV8sW\u001adwn\u001e\u000b\u0007\u0003/\t9-a3\t\u000f\u0005%g\u00031\u0001\u0002\u0018\u0005\u0001rN]5hS:\fGnV8sW\u001adwn\u001e\u0005\b\u0003_1\u0002\u0019AA\f\u0003e\u0019x/\u001b;dQ^{'o\u001b4m_^\f5\r^5wKN#\u0018\r^3\u0015\t\u0005E\u0017Q\u001b\u000b\u0005\u0003[\u000b\u0019\u000eC\u0004\u0002&]\u0001\u001d!a\n\t\u000f\u0005mr\u00031\u0001\u0002>\u00059R\u000f\u001d3bi\u0016<vN]6gY><8/S:BGRLg/\u001a\u000b\u0007\u00037\fy.!:\u0015\t\u00055\u0016Q\u001c\u0005\b\u0003KA\u00029AA\u0014\u0011\u001d\t\t\u000f\u0007a\u0001\u0003G\f1!\u001b3t!\u0019\ti%!\u0018\u0002>!9\u0011q\u001d\rA\u0002\u0005=\u0016\u0001E5t\u0003\u000e$\u0018N^3OK^4\u0016\r\\;f\u0003=9W\r\u001e)s_*,7\r\u001e(b[\u0016\u001cHCAAw)\u0011\ty/a>\u0011\r\u00055\u00111CAy!\u0019\tI*a=\u0002\u0018&!\u0011Q_AS\u0005\r\u0019V\r\u001e\u0005\b\u0003KI\u00029AA\u0014\u0003-9W\r\u001e)s_*,7\r^:\u0015\u0005\u0005uH\u0003BA\u0000\u0005\u0013\u0001b!!\u0004\u0002\u0014\t\u0005\u0001CBA'\u0003;\u0012\u0019\u0001\u0005\u0003\u0002\u001a\t\u0015\u0011\u0002\u0002B\u0004\u00037\u0011q\u0001\u0015:pU\u0016\u001cG\u000fC\u0004\u0002&i\u0001\u001d!a\n\u0002\u001f\u001d,G\u000f\u0015:pU\u0016\u001cGo]%oM>$\"Aa\u0004\u0015\t\tE!1\u0004\t\u0007\u0003\u001b\t\u0019Ba\u0005\u0011\r\u00055\u0013Q\fB\u000b!\u0011\tIBa\u0006\n\t\te\u00111\u0004\u0002\f!J|'.Z2u\u0013:4w\u000eC\u0004\u0002&m\u0001\u001d!a\n\u0002\u0019I,hnV8sW\u001adwn^:\u0015\t\t\u0005\"Q\u0005\u000b\u0005\u0003[\u0013\u0019\u0003C\u0004\u0002&q\u0001\u001d!a\n\t\u000f\t\u001dB\u00041\u0001\u0002d\u0006Yqo\u001c:lM2|w/\u00133t\u0003=\u0011XO\\,pe.4Gn\\<K_\n\u001cHC\u0002B\u0017\u0005c\u0011)\u0004\u0006\u0003\u0002.\n=\u0002bBA\u0013;\u0001\u000f\u0011q\u0005\u0005\b\u0005gi\u0002\u0019AA\u001f\u0003)9xN]6gY><\u0018\n\u001a\u0005\b\u0005oi\u0002\u0019AAr\u0003\u0019QwNY%eg\u0006yQ\r\u001f9peR<vN]6gY><8\u000f\u0006\u0003\u0003>\t-C\u0003\u0002B \u0005\u0013\u0002b!!\u0004\u0002\u0014\t\u0005\u0003CBA'\u0003;\u0012\u0019\u0005\u0005\u0003\u0002\u001a\t\u0015\u0013\u0002\u0002B$\u00037\u00111dV8sW\u001adwn^%na>\u0014H/\u0012=q_J$xK]1qa\u0016\u0014\bbBA\u0013=\u0001\u000f\u0011q\u0005\u0005\b\u0005Oq\u0002\u0019AAr\u0003=IW\u000e]8si^{'o\u001b4m_^\u001cH\u0003\u0002B)\u00053\"BAa\u0015\u0003XA1\u0011QBA\n\u0005+\u0002b!!\u0014\u0002^\u0005]\u0001bBA\u0013?\u0001\u000f\u0011q\u0005\u0005\b\u00057z\u0002\u0019\u0001B!\u0003=9xN]6gY><\u0018*\u001c9peR\u001c\u0018aF2p]Z,'\u000f\u001e+p/>\u00148N\u001a7po*{\u0017N\\3e)\u0011\u0011\tG!\u001a\u0015\t\u0005-!1\r\u0005\b\u0003K\u0001\u00039AA\u0014\u0011\u001d\u00119\u0007\ta\u0001\u0005\u0007\nab^8sW\u001adwn^%na>\u0014H/\u0001\rd_:4XM\u001d;U_^{'o\u001b4m_^Tu.\u001b8fIN$BA!\u001c\u0003rQ!!1\u000bB8\u0011\u001d\t)#\ta\u0002\u0003OAqAa\u0017\"\u0001\u0004\u0011\t%A\nsKN|GN^3K_\n$V-\u001c9mCR,7\u000f\u0006\u0003\u0003x\tmD\u0003\u0002B*\u0005sBq!!\n#\u0001\b\t9\u0003C\u0004\u0003\\\t\u0002\rA!\u0011\u00021I,7/\u001a;TG\",G-\u001e7fe&s7\u000f^1oG\u0016LE\r\u0006\u0003\u0003V\t\u0005\u0005b\u0002BBG\u0001\u0007!QK\u0001\u0010o>\u00148N\u001a7po*{\u0017N\\3eg\"\u001a\u0001Aa\"\u0011\t\t%%1S\u0007\u0003\u0005\u0017SAA!$\u0003\u0010\u0006Q1\u000f^3sK>$\u0018\u0010]3\u000b\u0007\tEU0A\btaJLgn\u001a4sC6,wo\u001c:l\u0013\u0011\u0011)Ja#\u0003\u000fM+'O^5dK\u0002")
public class WorkflowServiceImpl
implements WorkflowService,
UserDetailsService {
    private final WorkflowRepository workflowRepository;
    private final DagInstanceRepository dagInstanceRepository;
    private final DagInstanceService dagInstanceService;
    private final JobTemplateService jobTemplateService;
    private final WorkflowValidationService workflowValidationService;
    private final GeneralConfig generalConfig;
    private final Logger serviceLogger;

    public Function0<String> getUserName() {
        return UserDetailsService.getUserName$((UserDetailsService)this);
    }

    public WorkflowRepository workflowRepository() {
        return this.workflowRepository;
    }

    public DagInstanceRepository dagInstanceRepository() {
        return this.dagInstanceRepository;
    }

    public DagInstanceService dagInstanceService() {
        return this.dagInstanceService;
    }

    public JobTemplateService jobTemplateService() {
        return this.jobTemplateService;
    }

    public WorkflowValidationService workflowValidationService() {
        return this.workflowValidationService;
    }

    private Logger serviceLogger() {
        return this.serviceLogger;
    }

    public Future<WorkflowJoined> createWorkflow(WorkflowJoined workflow, ExecutionContext ec) {
        String userName = (String)this.getUserName().apply();
        return this.workflowValidationService().validateOnInsert(workflow, ec).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.workflowRepository().insertWorkflow(workflow, userName, ec).flatMap((Function1 & Serializable & scala.Serializable)workflowId -> WorkflowServiceImpl.$anonfun$createWorkflow$2((WorkflowServiceImpl)this, (ExecutionContext)ec, (long)BoxesRunTime.unboxToLong((Object)workflowId)), ec), ec);
    }

    public Future<WorkflowJoined> getWorkflow(long id, ExecutionContext ec) {
        return this.workflowRepository().getWorkflow(id, ec);
    }

    public Future<Seq<Workflow>> getWorkflows(ExecutionContext ec) {
        return this.workflowRepository().getWorkflows(ec);
    }

    public Future<TableSearchResponse<Workflow>> searchWorkflows(TableSearchRequest searchRequest, ExecutionContext ec) {
        return this.workflowRepository().searchWorkflows(searchRequest, ec);
    }

    public Future<Seq<Workflow>> getWorkflowsByProjectName(String projectName, ExecutionContext ec) {
        return this.workflowRepository().getWorkflowsByProjectName(projectName, ec);
    }

    public Future<Object> deleteWorkflow(long id, ExecutionContext ec) {
        String userName = (String)this.getUserName().apply();
        return this.workflowRepository().deleteWorkflow(id, userName, ec).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WorkflowServiceImpl.$anonfun$deleteWorkflow$1((BoxedUnit)x$1)), ec);
    }

    public Future<WorkflowJoined> updateWorkflow(WorkflowJoined workflow, ExecutionContext ec) {
        String userName = (String)this.getUserName().apply();
        return this.getWorkflow(workflow.id(), ec).flatMap((Function1 & Serializable & scala.Serializable)originalWorkflow -> this.workflowValidationService().validateOnUpdate(originalWorkflow, workflow, ec).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            WorkflowJoined mergedWorkflow = this.mergeWithOriginalWorkflow(originalWorkflow, workflow);
            return new Tuple2(x$2, (Object)mergedWorkflow);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            WorkflowJoined mergedWorkflow = (WorkflowJoined)tuple2._2();
            Future future = this.workflowRepository().updateWorkflow(mergedWorkflow, userName, ec).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.getWorkflow(workflow.id(), ec).map((Function1 & Serializable & scala.Serializable)updatedWorkflow -> updatedWorkflow, ec), ec);
            return future;
        }, ec), ec);
    }

    private WorkflowJoined mergeWithOriginalWorkflow(WorkflowJoined originalWorkflow, WorkflowJoined workflow) {
        long x$7 = originalWorkflow.id();
        LocalDateTime x$8 = originalWorkflow.created();
        Option x$9 = originalWorkflow.updated();
        long x$10 = workflow.version();
        Option x$11 = originalWorkflow.schedulerInstanceId();
        long x$1 = originalWorkflow.sensor().id();
        long x$2 = originalWorkflow.id();
        SensorProperties x$3 = workflow.sensor().properties();
        Sensor x$12 = workflow.sensor().copy(x$2, x$3, x$1);
        long x$4 = originalWorkflow.dagDefinitionJoined().id();
        long x$5 = originalWorkflow.id();
        Seq x$6 = workflow.dagDefinitionJoined().copy$default$2();
        DagDefinitionJoined x$13 = workflow.dagDefinitionJoined().copy(x$5, x$6, x$4);
        String x$14 = workflow.copy$default$1();
        boolean x$15 = workflow.copy$default$2();
        String x$16 = workflow.copy$default$3();
        return workflow.copy(x$14, x$15, x$16, x$8, x$9, x$10, x$11, x$12, x$13, x$7);
    }

    public Future<Object> switchWorkflowActiveState(long id, ExecutionContext ec) {
        String userName = (String)this.getUserName().apply();
        return this.workflowRepository().switchWorkflowActiveState(id, userName, ec).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)WorkflowServiceImpl.$anonfun$switchWorkflowActiveState$1((BoxedUnit)x$4)), ec);
    }

    public Future<Object> updateWorkflowsIsActive(Seq<Object> ids, boolean isActiveNewValue, ExecutionContext ec) {
        String userName = (String)this.getUserName().apply();
        return this.workflowRepository().updateWorkflowsIsActive(ids, isActiveNewValue, userName, ec).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)WorkflowServiceImpl.$anonfun$updateWorkflowsIsActive$1((BoxedUnit)x$5)), ec);
    }

    public Future<Set<String>> getProjectNames(ExecutionContext ec) {
        return this.workflowRepository().getProjectNames(ec).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.toSet(), ec);
    }

    public Future<Seq<Project>> getProjects(ExecutionContext ec) {
        return this.workflowRepository().getProjects(ec);
    }

    public Future<Seq<ProjectInfo>> getProjectsInfo(ExecutionContext ec) {
        return this.workflowRepository().getProjectsInfo(ec);
    }

    public Future<Object> runWorkflows(Seq<Object> workflowIds, ExecutionContext ec) {
        String userName = (String)this.getUserName().apply();
        int n = ((SeqLike)workflowIds.distinct()).length();
        switch (n) {
            default: 
        }
        if (n == 1) {
            throw new ApiException((ApiError)new GenericError("More than 1 workflow has to be triggered!", GenericError$.MODULE$.apply$default$2()));
        }
        if (n > this.generalConfig.maximumNumberOfWorkflowsInBulkRun()) {
            throw new ApiException((ApiError)new GenericError(new StringBuilder(36).append("Cannot trigger more than ").append(this.generalConfig.maximumNumberOfWorkflowsInBulkRun()).append(" workflows!").toString(), GenericError$.MODULE$.apply$default$2()));
        }
        this.serviceLogger().debug(new StringBuilder(63).append("User: ").append(userName).append(" called bulk run workflows. Workflows: ").append(workflowIds).append(" will be executed.").toString());
        return this.workflowRepository().getWorkflows((Seq)workflowIds.distinct(), ec).flatMap((Function1 & Serializable & scala.Serializable)joinedWorkflows -> Future$.MODULE$.sequence((TraversableOnce)joinedWorkflows.map((Function1 & Serializable & scala.Serializable)joinedWorkflow -> this.dagInstanceService().createDagInstance(joinedWorkflow.dagDefinitionJoined(), userName, this.dagInstanceService().createDagInstance$default$3(), ec), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom(), ec).flatMap((Function1 & Serializable & scala.Serializable)dagInstanceJoined -> this.dagInstanceRepository().insertJoinedDagInstances(dagInstanceJoined, ec).map((Function1 & Serializable & scala.Serializable)_ -> BoxesRunTime.boxToBoolean((boolean)WorkflowServiceImpl.$anonfun$runWorkflows$4((BoxedUnit)_)), ec), ec), ec);
    }

    public Future<Object> runWorkflowJobs(long workflowId, Seq<Object> jobIds, ExecutionContext ec) {
        String userName = (String)this.getUserName().apply();
        return this.workflowRepository().getWorkflow(workflowId, ec).flatMap((Function1 & Serializable & scala.Serializable)joinedWorkflow -> {
            Future future;
            boolean anyJobIdIsNotPartOfWorkflow;
            DagDefinitionJoined dagDefinitionJoined = joinedWorkflow.dagDefinitionJoined();
            boolean bl = anyJobIdIsNotPartOfWorkflow = !jobIds.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)id -> ((SeqLike)dagDefinitionJoined.jobDefinitions().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)WorkflowServiceImpl.$anonfun$runWorkflowJobs$3((JobDefinition)x$7)), Seq$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToLong((long)id)));
            if (anyJobIdIsNotPartOfWorkflow) {
                future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
            } else {
                Seq x$1 = (Seq)dagDefinitionJoined.jobDefinitions().filter((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)WorkflowServiceImpl.$anonfun$runWorkflowJobs$4((Seq)jobIds, (JobDefinition)job)));
                long x$2 = dagDefinitionJoined.copy$default$1();
                long x$3 = dagDefinitionJoined.copy$default$3();
                DagDefinitionJoined dagDefinitionWithFilteredJobs = dagDefinitionJoined.copy(x$2, x$1, x$3);
                future = this.dagInstanceService().createDagInstance(dagDefinitionWithFilteredJobs, userName, this.dagInstanceService().createDagInstance$default$3(), ec).flatMap((Function1 & Serializable & scala.Serializable)dagInstanceJoined -> this.dagInstanceRepository().insertJoinedDagInstance(dagInstanceJoined, ec).map((Function1 & Serializable & scala.Serializable)_ -> BoxesRunTime.boxToBoolean((boolean)WorkflowServiceImpl.$anonfun$runWorkflowJobs$6((BoxedUnit)_)), ec), ec);
            }
            return future;
        }, ec);
    }

    public Future<Seq<WorkflowImportExportWrapper>> exportWorkflows(Seq<Object> workflowIds, ExecutionContext ec) {
        return this.workflowRepository().getWorkflows(workflowIds, ec).map((Function1 & Serializable & scala.Serializable)workflows -> {
            Seq allJobTemplateIds = (Seq)((SeqLike)workflows.flatMap((Function1 & Serializable & scala.Serializable)x$8 -> (Seq)x$8.dagDefinitionJoined().jobDefinitions().flatMap((Function1 & Serializable & scala.Serializable)x$9 -> Option$.MODULE$.option2Iterable(x$9.jobTemplateId()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).distinct();
            return new Tuple2(workflows, (Object)allJobTemplateIds);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> {
            Tuple2 tuple2 = x$11;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq workflows = (Seq)tuple2._1();
            Seq allJobTemplateIds = (Seq)tuple2._2();
            Future future = this.jobTemplateService().getJobTemplatesByIds(allJobTemplateIds, ec).map((Function1 & Serializable & scala.Serializable)allJobTemplates -> (Seq)workflows.map((Function1 & Serializable & scala.Serializable)workflow -> {
                Seq jobTemplateIds = (Seq)((SeqLike)workflow.dagDefinitionJoined().jobDefinitions().flatMap((Function1 & Serializable & scala.Serializable)x$10 -> Option$.MODULE$.option2Iterable(x$10.jobTemplateId()), Seq$.MODULE$.canBuildFrom())).distinct();
                Seq jobTemplates = (Seq)allJobTemplates.filter((Function1 & Serializable & scala.Serializable)jobTemplate -> BoxesRunTime.boxToBoolean((boolean)WorkflowServiceImpl.$anonfun$exportWorkflows$8((Seq)jobTemplateIds, (JobTemplate)jobTemplate)));
                return new WorkflowImportExportWrapper(workflow, jobTemplates);
            }, Seq$.MODULE$.canBuildFrom()), ec);
            return future;
        }, ec);
    }

    public Future<Seq<WorkflowJoined>> importWorkflows(Seq<WorkflowImportExportWrapper> workflowImports, ExecutionContext ec) {
        String userName = (String)this.getUserName().apply();
        return this.convertToWorkflowJoineds(workflowImports, ec).map((Function1 & Serializable & scala.Serializable)workflowJoineds -> {
            Seq deactivatedWorkflows = (Seq)workflowJoineds.map((Function1 & Serializable & scala.Serializable)workflowJoined -> {
                boolean x$1 = false;
                String x$2 = workflowJoined.copy$default$1();
                String x$3 = workflowJoined.copy$default$3();
                LocalDateTime x$4 = workflowJoined.copy$default$4();
                Option x$5 = workflowJoined.copy$default$5();
                long x$6 = workflowJoined.copy$default$6();
                Option x$7 = workflowJoined.copy$default$7();
                Sensor x$8 = workflowJoined.copy$default$8();
                DagDefinitionJoined x$9 = workflowJoined.copy$default$9();
                long x$10 = workflowJoined.copy$default$10();
                return workflowJoined.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
            }, Seq$.MODULE$.canBuildFrom());
            return new Tuple2(workflowJoineds, (Object)deactivatedWorkflows);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq deactivatedWorkflows = (Seq)tuple2._2();
            Future future = this.workflowValidationService().validateOnInsert(deactivatedWorkflows, ec).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.workflowRepository().insertWorkflows(deactivatedWorkflows, userName, ec).flatMap((Function1 & Serializable & scala.Serializable)workflowIds -> this.workflowRepository().getWorkflows(workflowIds, ec).map((Function1 & Serializable & scala.Serializable)workflows -> workflows, ec), ec), ec);
            return future;
        }, ec);
    }

    public Future<WorkflowJoined> convertToWorkflowJoined(WorkflowImportExportWrapper workflowImport, ExecutionContext ec) {
        return this.convertToWorkflowJoineds((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WorkflowImportExportWrapper[]{workflowImport})), ec).transform((Function1 & Serializable & scala.Serializable)workflowJoineds -> {
            if (workflowJoineds.size() != 1) {
                throw new RuntimeException(new StringBuilder(21).append("Expected size 1, got ").append(workflowJoineds.size()).toString());
            }
            return (WorkflowJoined)workflowJoineds.head();
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (!(throwable instanceof ApiException)) {
                throw new MatchError((Object)throwable);
            }
            ApiException apiException = (ApiException)throwable;
            ApiException apiException2 = new ApiException((Seq)apiException.apiErrors().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.unwrapError(), Seq$.MODULE$.canBuildFrom()));
            return apiException2;
        }, ec);
    }

    private Future<Seq<WorkflowJoined>> convertToWorkflowJoineds(Seq<WorkflowImportExportWrapper> workflowImports, ExecutionContext ec) {
        return this.resolveJobTemplates(workflowImports, ec).map((Function1 & Serializable & scala.Serializable)workflowJoineds -> this.resetSchedulerInstanceId(workflowJoineds), ec);
    }

    private Future<Seq<WorkflowJoined>> resolveJobTemplates(Seq<WorkflowImportExportWrapper> workflowImports, ExecutionContext ec) {
        Seq jobTemplatesNames = (Seq)((SeqLike)workflowImports.flatMap((Function1 & Serializable & scala.Serializable)x$14 -> (Seq)x$14.jobTemplates().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).distinct();
        return this.jobTemplateService().getJobTemplateIdsByNames(jobTemplatesNames, ec).flatMap((Function1 & Serializable & scala.Serializable)newNameIdMap -> {
            Future future;
            Seq workflowJoinedsEit = (Seq)workflowImports.map((Function1 & Serializable & scala.Serializable)workflowImport -> {
                Left left;
                Map oldIdNameMap = ((TraversableOnce)workflowImport.jobTemplates().map((Function1 & Serializable & scala.Serializable)jobTemplate -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)jobTemplate.id())), (Object)jobTemplate.name()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                Set missingTemplates = (Set)oldIdNameMap.values().toSet().diff((GenSet)newNameIdMap.keySet());
                if (missingTemplates.nonEmpty()) {
                    left = package$.MODULE$.Left().apply((Object)BulkOperationError$.MODULE$.apply(workflowImport.workflowJoined(), (ApiError)new GenericError(new StringBuilder(99).append("The following Job Templates don't exist yet and have to be created before importing").append(" this workflow: ").append(missingTemplates.reduce((Function2 & Serializable & scala.Serializable)(x$16, x$17) -> new StringBuilder(2).append((String)x$16).append(", ").append((String)x$17).toString())).toString(), GenericError$.MODULE$.apply$default$2())));
                } else {
                    Seq x$7 = (Seq)workflowImport.workflowJoined().dagDefinitionJoined().jobDefinitions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Option option;
                        JobDefinition jobDefinition;
                        Option option2;
                        JobDefinition jobDefinition2 = x0$1;
                        if (jobDefinition2 != null && (option2 = jobDefinition2.jobTemplateId()) instanceof Some) {
                            Some some = (Some)option2;
                            long jobTemplateId = BoxesRunTime.unboxToLong((Object)some.value());
                            Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)WorkflowServiceImpl.getNewId$1((long)jobTemplateId, (Map)oldIdNameMap, (Map)newNameIdMap)));
                            long x$2 = jobDefinition2.copy$default$1();
                            String x$3 = jobDefinition2.copy$default$3();
                            JobDefinitionParameters x$4 = jobDefinition2.copy$default$4();
                            int x$5 = jobDefinition2.copy$default$5();
                            long x$6 = jobDefinition2.copy$default$6();
                            jobDefinition = jobDefinition2.copy(x$2, (Option)x$1, x$3, x$4, x$5, x$6);
                        } else if (jobDefinition2 != null && None$.MODULE$.equals(option = jobDefinition2.jobTemplateId())) {
                            jobDefinition = jobDefinition2;
                        } else {
                            throw new MatchError((Object)jobDefinition2);
                        }
                        return jobDefinition;
                    }, Seq$.MODULE$.canBuildFrom());
                    long x$8 = workflowImport.workflowJoined().dagDefinitionJoined().copy$default$1();
                    long x$9 = workflowImport.workflowJoined().dagDefinitionJoined().copy$default$3();
                    DagDefinitionJoined x$10 = workflowImport.workflowJoined().dagDefinitionJoined().copy(x$8, x$7, x$9);
                    String x$11 = workflowImport.workflowJoined().copy$default$1();
                    boolean x$12 = workflowImport.workflowJoined().copy$default$2();
                    String x$13 = workflowImport.workflowJoined().copy$default$3();
                    LocalDateTime x$14 = workflowImport.workflowJoined().copy$default$4();
                    Option x$15 = workflowImport.workflowJoined().copy$default$5();
                    long x$162 = workflowImport.workflowJoined().copy$default$6();
                    Option x$172 = workflowImport.workflowJoined().copy$default$7();
                    Sensor x$18 = workflowImport.workflowJoined().copy$default$8();
                    long x$19 = workflowImport.workflowJoined().copy$default$10();
                    WorkflowJoined workflowWithResolvedJobTemplateIds = workflowImport.workflowJoined().copy(x$11, x$12, x$13, x$14, x$15, x$162, x$172, x$18, x$10, x$19);
                    left = package$.MODULE$.Right().apply((Object)workflowWithResolvedJobTemplateIds);
                }
                return left;
            }, Seq$.MODULE$.canBuildFrom());
            if (workflowJoinedsEit.forall((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)WorkflowServiceImpl.$anonfun$resolveJobTemplates$8((Either)x$18)))) {
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Seq)workflowJoinedsEit.map((Function1 & Serializable & scala.Serializable)x$19 -> (WorkflowJoined)x$19.right().get(), Seq$.MODULE$.canBuildFrom()), ec);
            } else {
                Seq allErrors = (Seq)((TraversableLike)workflowJoinedsEit.filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)WorkflowServiceImpl.$anonfun$resolveJobTemplates$11((Either)x$20)))).map((Function1 & Serializable & scala.Serializable)x$21 -> (BulkOperationError)x$21.left().get(), Seq$.MODULE$.canBuildFrom());
                future = Future$.MODULE$.failed((Throwable)new ApiException(allErrors));
            }
            return future;
        }, ec);
    }

    private Seq<WorkflowJoined> resetSchedulerInstanceId(Seq<WorkflowJoined> workflowJoineds) {
        return (Seq)workflowJoineds.map((Function1 & Serializable & scala.Serializable)x$22 -> {
            None$ x$1 = None$.MODULE$;
            String x$2 = x$22.copy$default$1();
            boolean x$3 = x$22.copy$default$2();
            String x$4 = x$22.copy$default$3();
            LocalDateTime x$5 = x$22.copy$default$4();
            Option x$6 = x$22.copy$default$5();
            long x$7 = x$22.copy$default$6();
            Sensor x$8 = x$22.copy$default$8();
            DagDefinitionJoined x$9 = x$22.copy$default$9();
            long x$10 = x$22.copy$default$10();
            return x$22.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Option)x$1, x$8, x$9, x$10);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Future $anonfun$createWorkflow$2(WorkflowServiceImpl $this, ExecutionContext ec$1, long workflowId) {
        return $this.getWorkflow(workflowId, ec$1).map((Function1 & Serializable & scala.Serializable)workflowJoined -> workflowJoined, ec$1);
    }

    public static final /* synthetic */ boolean $anonfun$deleteWorkflow$1(BoxedUnit x$1) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$switchWorkflowActiveState$1(BoxedUnit x$4) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$updateWorkflowsIsActive$1(BoxedUnit x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$runWorkflows$4(BoxedUnit _) {
        return true;
    }

    public static final /* synthetic */ long $anonfun$runWorkflowJobs$3(JobDefinition x$7) {
        return x$7.id();
    }

    public static final /* synthetic */ boolean $anonfun$runWorkflowJobs$4(Seq jobIds$1, JobDefinition job) {
        return jobIds$1.contains((Object)BoxesRunTime.boxToLong((long)job.id()));
    }

    public static final /* synthetic */ boolean $anonfun$runWorkflowJobs$6(BoxedUnit _) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$exportWorkflows$8(Seq jobTemplateIds$1, JobTemplate jobTemplate) {
        return jobTemplateIds$1.contains((Object)BoxesRunTime.boxToLong((long)jobTemplate.id()));
    }

    private static final long getNewId$1(long oldTemplateId, Map oldIdNameMap$1, Map newNameIdMap$1) {
        long x;
        String x2;
        Option option = oldIdNameMap$1.get((Object)BoxesRunTime.boxToLong((long)oldTemplateId));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Template Id ").append(oldTemplateId).append(" is not referenced in ").append(oldIdNameMap$1).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String string = x2 = (String)some.value();
        String name = string;
        Option option2 = newNameIdMap$1.get((Object)name);
        if (!(option2 instanceof Some)) {
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException(new StringBuilder(35).append("Template name ").append(name).append(" is not reference in ").append(newNameIdMap$1).toString());
            }
            throw new MatchError((Object)option2);
        }
        Some some2 = (Some)option2;
        long l = x = BoxesRunTime.unboxToLong((Object)some2.value());
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$resolveJobTemplates$8(Either x$18) {
        return x$18.isRight();
    }

    public static final /* synthetic */ boolean $anonfun$resolveJobTemplates$11(Either x$20) {
        return x$20.isLeft();
    }

    public WorkflowServiceImpl(WorkflowRepository workflowRepository, DagInstanceRepository dagInstanceRepository, DagInstanceService dagInstanceService, JobTemplateService jobTemplateService, WorkflowValidationService workflowValidationService, GeneralConfig generalConfig) {
        this.workflowRepository = workflowRepository;
        this.dagInstanceRepository = dagInstanceRepository;
        this.dagInstanceService = dagInstanceService;
        this.jobTemplateService = jobTemplateService;
        this.workflowValidationService = workflowValidationService;
        this.generalConfig = generalConfig;
        UserDetailsService.$init$((UserDetailsService)this);
        this.serviceLogger = LoggerFactory.getLogger((Class)this.getClass());
    }
}

